/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding;

import java.nio.ByteBuffer;
import org.terracotta.runnel.decoding.ArrayDecoder;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.PrimitiveDecodingSupport;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.fields.BoolField;
import org.terracotta.runnel.decoding.fields.ByteBufferField;
import org.terracotta.runnel.decoding.fields.CharField;
import org.terracotta.runnel.decoding.fields.EnumField;
import org.terracotta.runnel.decoding.fields.FloatingPoint64Field;
import org.terracotta.runnel.decoding.fields.Int32Field;
import org.terracotta.runnel.decoding.fields.Int64Field;
import org.terracotta.runnel.decoding.fields.StringField;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.metadata.FieldDecoder;
import org.terracotta.runnel.utils.ReadBuffer;

public class StructDecoder
implements PrimitiveDecodingSupport {
    private final FieldDecoder fieldDecoder;
    private final ReadBuffer readBuffer;
    private final StructDecoder parent;

    public StructDecoder(StructField structField, ReadBuffer readBuffer) {
        this(structField, readBuffer, null);
    }

    public StructDecoder(StructField structField, ReadBuffer readBuffer, StructDecoder parent) {
        this.parent = parent;
        int size = readBuffer.getVlqInt();
        this.readBuffer = readBuffer.limit(size);
        this.fieldDecoder = structField.getMetadata().fieldDecoder(this.readBuffer);
    }

    @Override
    public Boolean bool(String name) {
        return (Boolean)this.fieldDecoder.decodeValue(name, BoolField.class);
    }

    @Override
    public Character chr(String name) {
        return (Character)this.fieldDecoder.decodeValue(name, CharField.class);
    }

    @Override
    public Integer int32(String name) {
        return (Integer)this.fieldDecoder.decodeValue(name, Int32Field.class);
    }

    @Override
    public <E> Enm<E> enm(String name) {
        Enm enm = (Enm)this.fieldDecoder.decodeValue(name, EnumField.class);
        if (enm == null) {
            return new Enm(name);
        }
        return enm;
    }

    @Override
    public Long int64(String name) {
        return (Long)this.fieldDecoder.decodeValue(name, Int64Field.class);
    }

    @Override
    public Double fp64(String name) {
        return (Double)this.fieldDecoder.decodeValue(name, FloatingPoint64Field.class);
    }

    @Override
    public String string(String name) {
        return (String)this.fieldDecoder.decodeValue(name, StringField.class);
    }

    @Override
    public ByteBuffer byteBuffer(String name) {
        return (ByteBuffer)this.fieldDecoder.decodeValue(name, ByteBufferField.class);
    }

    public ArrayDecoder<Integer> int32s(String name) {
        return this.fieldDecoder.decodeValueArray(name, Int32Field.class, this);
    }

    public ArrayDecoder<Boolean> bools(String name) {
        return this.fieldDecoder.decodeValueArray(name, BoolField.class, this);
    }

    public ArrayDecoder<Character> chrs(String name) {
        return this.fieldDecoder.decodeValueArray(name, CharField.class, this);
    }

    public ArrayDecoder<Long> int64s(String name) {
        return this.fieldDecoder.decodeValueArray(name, Int64Field.class, this);
    }

    public ArrayDecoder<Double> fp64s(String name) {
        return this.fieldDecoder.decodeValueArray(name, FloatingPoint64Field.class, this);
    }

    public ArrayDecoder<String> strings(String name) {
        return this.fieldDecoder.decodeValueArray(name, StringField.class, this);
    }

    public StructDecoder struct(String name) {
        return this.fieldDecoder.decodeStruct(name, this);
    }

    public StructArrayDecoder structs(String name) {
        return this.fieldDecoder.decodeStructArray(name, this);
    }

    public StructDecoder end() {
        if (this.parent == null) {
            throw new IllegalStateException("Cannot end root decoder");
        }
        this.readBuffer.skipAll();
        return this.parent;
    }
}

