/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.encoding.StructEncoder;
import org.terracotta.runnel.utils.ReadBuffer;

public class Struct {
    private final StructField root;

    public Struct(StructField root) {
        this.root = root;
    }

    List<? extends Field> getRootSubFields() {
        return this.root.subFields();
    }

    public StructEncoder encoder() {
        return new StructEncoder(this.root);
    }

    public StructDecoder decoder(ByteBuffer byteBuffer) {
        return new StructDecoder(this.root, new ReadBuffer(byteBuffer));
    }

    public void dump(ByteBuffer byteBuffer, PrintStream out) {
        Map<Integer, Field> fieldsByInteger = this.root.getMetadata().buildFieldsByIndexMap();
        ReadBuffer readBuffer = new ReadBuffer(byteBuffer);
        int totalSize = readBuffer.getVlqInt();
        readBuffer = readBuffer.limit(totalSize);
        while (!readBuffer.limitReached()) {
            int index = readBuffer.getVlqInt();
            out.append("index: ").append(Integer.toString(index));
            Field field = fieldsByInteger.get(index);
            if (field != null) {
                field.dump(readBuffer, out, 0);
            } else {
                int fieldSize = readBuffer.getVlqInt();
                out.append(" size: ").append(Integer.toString(fieldSize));
                ReadBuffer fieldReadBuffer = readBuffer.limit(fieldSize);
                out.append(" type: ???");
                fieldReadBuffer.skipAll();
            }
            out.append("\n");
        }
    }
}

