/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.metadata.FieldDecoder;
import org.terracotta.runnel.metadata.FieldSearcher;
import org.terracotta.runnel.utils.ReadBuffer;

public class Metadata {
    private final Map<String, Field> fieldsByName = new HashMap<String, Field>();

    public Metadata(List<? extends Field> metadata) {
        for (Field field : metadata) {
            this.fieldsByName.put(field.name(), field);
        }
    }

    public FieldSearcher fieldSearcher() {
        return new FieldSearcher(this);
    }

    public FieldDecoder fieldDecoder(ReadBuffer readBuffer) {
        return new FieldDecoder(this, readBuffer);
    }

    public Map<Integer, Field> buildFieldsByIndexMap() {
        HashMap<Integer, Field> map = new HashMap<Integer, Field>();
        for (Field field : this.fieldsByName.values()) {
            map.put(field.index(), field);
        }
        return map;
    }

    Field getFieldByName(String name) {
        return this.fieldsByName.get(name);
    }
}

