/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.ClusteredEhcacheIdentity;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.CodecUtil;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Util;

class PassiveReplicationMessageCodec {
    private static final byte OP_CODE_SIZE = 1;
    private static final byte CACHE_ID_LEN_SIZE = 4;
    private static final byte KEY_SIZE = 8;
    private static final byte MESSAGE_ID_SIZE = 24;
    private ChainCodec chainCodec = new ChainCodec();

    PassiveReplicationMessageCodec() {
    }

    public byte[] encode(PassiveReplicationMessage message) {
        switch (message.operation()) {
            case CLIENTID_TRACK_OP: {
                ByteBuffer encodedMsg = ByteBuffer.allocate(25);
                encodedMsg.put(message.getOpCode());
                encodedMsg.put(ClusteredEhcacheIdentity.serialize(message.getClientId()));
                encodedMsg.putLong(message.getId());
                return encodedMsg.array();
            }
            case CHAIN_REPLICATION_OP: {
                PassiveReplicationMessage.ChainReplicationMessage chainReplicationMessage = (PassiveReplicationMessage.ChainReplicationMessage)message;
                byte[] encodedChain = this.chainCodec.encode(chainReplicationMessage.getChain());
                int cacheIdLen = chainReplicationMessage.getCacheId().length();
                ByteBuffer encodedMsg = ByteBuffer.allocate(37 + encodedChain.length + 2 * cacheIdLen);
                encodedMsg.put(chainReplicationMessage.getOpCode());
                encodedMsg.put(ClusteredEhcacheIdentity.serialize(chainReplicationMessage.getClientId()));
                encodedMsg.putLong(chainReplicationMessage.getId());
                encodedMsg.putInt(cacheIdLen);
                CodecUtil.putStringAsCharArray(encodedMsg, chainReplicationMessage.getCacheId());
                encodedMsg.putLong(chainReplicationMessage.getKey());
                encodedMsg.put(encodedChain);
                return encodedMsg.array();
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                PassiveReplicationMessage.ClearInvalidationCompleteMessage clearInvalidationCompleteMessage = (PassiveReplicationMessage.ClearInvalidationCompleteMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(1 + 2 * clearInvalidationCompleteMessage.getCacheId().length());
                encodedMsg.put(message.getOpCode());
                CodecUtil.putStringAsCharArray(encodedMsg, clearInvalidationCompleteMessage.getCacheId());
                return encodedMsg.array();
            }
            case INVALIDATION_COMPLETE: {
                PassiveReplicationMessage.InvalidationCompleteMessage invalidationCompleteMessage = (PassiveReplicationMessage.InvalidationCompleteMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(9 + 2 * invalidationCompleteMessage.getCacheId().length());
                encodedMsg.put(message.getOpCode());
                encodedMsg.putLong(invalidationCompleteMessage.getKey());
                CodecUtil.putStringAsCharArray(encodedMsg, invalidationCompleteMessage.getCacheId());
                return encodedMsg.array();
            }
            case SERVER_STORE_LIFECYCLE_REPLICATION_OP: {
                PassiveReplicationMessage.ServerStoreLifeCycleReplicationMessage storeLifeCycleReplicationMessage = (PassiveReplicationMessage.ServerStoreLifeCycleReplicationMessage)message;
                byte[] encodedLifeCycleMsg = Util.marshall(storeLifeCycleReplicationMessage.getMessage());
                ByteBuffer encodedMsg = ByteBuffer.allocate(1 + encodedLifeCycleMsg.length);
                encodedMsg.put(message.getOpCode());
                encodedMsg.put(encodedLifeCycleMsg);
                return encodedMsg.array();
            }
        }
        throw new UnsupportedOperationException("This operation is not supported : " + (Object)((Object)message.operation()));
    }

    public EhcacheEntityMessage decode(byte[] payload) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        PassiveReplicationMessage.ReplicationOp replicationOp = PassiveReplicationMessage.ReplicationOp.getReplicationOp(byteBuffer.get());
        switch (replicationOp) {
            case CHAIN_REPLICATION_OP: {
                UUID clientId = PassiveReplicationMessageCodec.getClientId(byteBuffer);
                long msgId = byteBuffer.getLong();
                int length = byteBuffer.getInt();
                String cacheId = CodecUtil.getStringFromBuffer(byteBuffer, length);
                long key = byteBuffer.getLong();
                byte[] encodedChain = new byte[byteBuffer.remaining()];
                byteBuffer.get(encodedChain);
                Chain chain = this.chainCodec.decode(encodedChain);
                return new PassiveReplicationMessage.ChainReplicationMessage(cacheId, key, chain, msgId, clientId);
            }
            case CLIENTID_TRACK_OP: {
                UUID clientId = PassiveReplicationMessageCodec.getClientId(byteBuffer);
                long msgId = byteBuffer.getLong();
                return new PassiveReplicationMessage.ClientIDTrackerMessage(msgId, clientId);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                String cacheId = CodecUtil.getStringFromBuffer(byteBuffer, byteBuffer.remaining() / 2);
                return new PassiveReplicationMessage.ClearInvalidationCompleteMessage(cacheId);
            }
            case INVALIDATION_COMPLETE: {
                long key = byteBuffer.getLong();
                String cacheId = CodecUtil.getStringFromBuffer(byteBuffer, byteBuffer.remaining() / 2);
                return new PassiveReplicationMessage.InvalidationCompleteMessage(cacheId, key);
            }
            case SERVER_STORE_LIFECYCLE_REPLICATION_OP: {
                byte[] encodedLifeCycle = new byte[byteBuffer.remaining()];
                byteBuffer.get(encodedLifeCycle);
                LifecycleMessage lifecycleMessage = (LifecycleMessage)Util.unmarshall(encodedLifeCycle);
                return new PassiveReplicationMessage.ServerStoreLifeCycleReplicationMessage(lifecycleMessage);
            }
        }
        throw new UnsupportedOperationException("This operation code is not supported : " + (Object)((Object)replicationOp));
    }

    private static UUID getClientId(ByteBuffer payload) {
        long msb = payload.getLong();
        long lsb = payload.getLong();
        return new UUID(msb, lsb);
    }
}

