/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import java.util.ServiceLoader;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;

public class EntityClientServiceFactory {
    public static <T extends Entity, C> EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> creationServiceForType(Class<T> cls) {
        return EntityClientServiceFactory.creationServiceForType(cls, EntityClientServiceFactory.class.getClassLoader());
    }

    public static <T extends Entity, C> EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse> creationServiceForType(Class<T> cls, ClassLoader classLoader) {
        ServiceLoader<EntityClientService> serviceLoader = ServiceLoader.load(EntityClientService.class, classLoader);
        for (EntityClientService entityClientService : serviceLoader) {
            if (!entityClientService.handlesEntityType(cls)) continue;
            return entityClientService;
        }
        throw new IllegalArgumentException("Can't handle entity type " + cls.getName());
    }
}

