/*
 * Decompiled with CFR 0.152.
 */
package com.tc.io;

import java.io.OutputStream;

public final class TCByteArrayOutputStream
extends OutputStream {
    private int size;
    private byte[] buffer;

    public TCByteArrayOutputStream() {
        this(64);
    }

    public TCByteArrayOutputStream(int initialSize) {
        this.buffer = new byte[initialSize];
    }

    private void ensureCapacity(int newCap) {
        byte[] newBuffer = new byte[Math.max(this.buffer.length * 2, newCap)];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
        this.buffer = newBuffer;
    }

    @Override
    public final void write(int b) {
        int newSize = this.size + 1;
        if (newSize > this.buffer.length) {
            this.ensureCapacity(newSize);
        }
        this.buffer[this.size] = (byte)b;
        this.size = newSize;
    }

    @Override
    public final void write(byte[] b, int offset, int len) {
        int newSize = this.size + len;
        if (newSize > this.buffer.length) {
            this.ensureCapacity(newSize);
        }
        System.arraycopy(b, offset, this.buffer, this.size, len);
        this.size = newSize;
    }

    public final void reset() {
        this.size = 0;
    }

    public final byte[] getInternalArray() {
        return this.buffer;
    }

    public final int size() {
        return this.size;
    }
}

