/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.SecurityInfo;
import com.tc.util.Assert;
import java.io.Serializable;

public class ConnectionInfo
implements Serializable {
    public static final ConnectionInfo[] EMPTY_ARRAY = new ConnectionInfo[0];
    private final String hostname;
    private final int port;
    private final int server;
    private final SecurityInfo securityInfo;
    private String s;

    public ConnectionInfo(String hostname, int port) {
        this(hostname, port, new SecurityInfo());
    }

    public ConnectionInfo(String hostname, int port, SecurityInfo securityInfo) {
        this(hostname, port, 0, securityInfo);
    }

    public ConnectionInfo(String hostname, int port, int server) {
        this(hostname, port, server, new SecurityInfo());
    }

    public ConnectionInfo(String hostname, int port, int server, SecurityInfo securityInfo) {
        Assert.assertNotNull(hostname);
        this.hostname = hostname;
        this.port = port;
        this.server = server;
        this.securityInfo = securityInfo;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getServer() {
        return this.server;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionInfo) {
            ConnectionInfo other = (ConnectionInfo)o;
            return this.hostname.equals(other.getHostname()) && this.port == other.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.s == null ? (this.s = this.hostname + ":" + this.port) : this.s;
    }

    public SecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }
}

