/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.ClusterTopologyChangedListener;
import com.tc.net.core.ConnectionAddressIterator;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.SecurityInfo;
import com.tc.util.StringUtil;

public class ConnectionAddressProvider
implements ClusterTopologyChangedListener {
    private volatile ConnectionInfo[] addresses;

    public ConnectionAddressProvider(ConnectionInfo[] addresses) {
        this.addresses = addresses == null ? ConnectionInfo.EMPTY_ARRAY : addresses;
    }

    public synchronized String toString() {
        return "ConnectionAddressProvider(" + StringUtil.toString(this.addresses) + ")";
    }

    public synchronized ConnectionAddressIterator getIterator() {
        return new ConnectionAddressIterator(this.addresses);
    }

    @Override
    public synchronized void serversUpdated(ConnectionAddressProvider addressProvider) {
        this.addresses = addressProvider.addresses;
    }

    public String getId() {
        StringBuilder build = new StringBuilder();
        int sep = 32;
        for (ConnectionInfo info : this.addresses) {
            build.append(info.toString());
            build.append((char)sep);
            sep = 44;
        }
        return build.toString();
    }

    public SecurityInfo getSecurityInfo() {
        SecurityInfo securityInfo = null;
        for (ConnectionInfo address : this.addresses) {
            if (securityInfo != null && !securityInfo.equals(address.getSecurityInfo())) {
                throw new IllegalStateException("Multiple SecurityInfo differ!");
            }
            securityInfo = address.getSecurityInfo();
        }
        return securityInfo;
    }
}

