/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PlatformInfoRequest
extends AbstractGroupMessage {
    public static final int ERROR = 0;
    public static final int REQUEST = 1;
    public static final int RESPONSE_INFO = 2;
    public static final int RESPONSE_ADD = 3;
    public static final int RESPONSE_REMOVE = 4;
    public static final int BEST_EFFORTS_BATCH = 5;
    private long changeConsumerID;
    private String[] nodeParents;
    private String nodeName;
    private Serializable nodeValue;
    private Serializable serverInfo;
    private long[] consumerIDs;
    private String[] keys;
    private Serializable[] values;

    public static PlatformInfoRequest createEmptyRequest() {
        return new PlatformInfoRequest(1, -1L, null, null, null, null, null, null, null);
    }

    public static PlatformInfoRequest createAddNode(long consumerID, String[] parents, String name, Serializable value) {
        return new PlatformInfoRequest(3, consumerID, parents, name, value, null, null, null, null);
    }

    public static PlatformInfoRequest createRemoveNode(long consumerID, String[] parents, String name) {
        return new PlatformInfoRequest(4, consumerID, parents, name, null, null, null, null, null);
    }

    public static PlatformInfoRequest createServerInfoMessage(Serializable serverInfo) {
        return new PlatformInfoRequest(2, -1L, null, null, null, serverInfo, null, null, null);
    }

    public static PlatformInfoRequest createBestEffortsBatch(long[] consumerIDs, String[] keys, Serializable[] values) {
        Assert.assertTrue(consumerIDs.length > 0);
        return new PlatformInfoRequest(5, -1L, null, null, null, null, consumerIDs, keys, values);
    }

    public PlatformInfoRequest() {
        super(0);
    }

    private PlatformInfoRequest(int type, long changeConsumerID, String[] nodeParents, String nodeName, Serializable nodeValue, Serializable serverInfo, long[] consumerIDs, String[] keys, Serializable[] values) {
        super(type);
        this.changeConsumerID = changeConsumerID;
        this.nodeParents = nodeParents;
        this.nodeName = nodeName;
        this.nodeValue = nodeValue;
        this.serverInfo = serverInfo;
        this.consumerIDs = consumerIDs;
        this.keys = keys;
        this.values = values;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        switch (this.getType()) {
            case 1: {
                break;
            }
            case 2: {
                int valueSize = in.readInt();
                Assert.assertTrue(valueSize > 0);
                byte[] valueArray = new byte[valueSize];
                in.readFully(valueArray);
                this.serverInfo = this.deserialize(valueArray);
                break;
            }
            case 3: {
                this.changeConsumerID = in.readLong();
                int parentCount = in.readInt();
                this.nodeParents = new String[parentCount];
                for (int i = 0; i < parentCount; ++i) {
                    this.nodeParents[i] = in.readString();
                }
                this.nodeName = in.readString();
                int valueSize = in.readInt();
                if (valueSize > 0) {
                    byte[] valueArray = new byte[valueSize];
                    in.readFully(valueArray);
                    this.nodeValue = this.deserialize(valueArray);
                    break;
                }
                this.nodeValue = null;
                break;
            }
            case 4: {
                this.changeConsumerID = in.readLong();
                int parentCount = in.readInt();
                this.nodeParents = new String[parentCount];
                for (int i = 0; i < parentCount; ++i) {
                    this.nodeParents[i] = in.readString();
                }
                this.nodeName = in.readString();
                break;
            }
            case 5: {
                int tupleCount = in.readInt();
                long[] consumerIDs = new long[tupleCount];
                String[] keys = new String[tupleCount];
                Serializable[] values = new Serializable[tupleCount];
                for (int i = 0; i < tupleCount; ++i) {
                    consumerIDs[i] = in.readLong();
                    keys[i] = in.readString();
                    int valueSize = in.readInt();
                    if (valueSize > 0) {
                        byte[] valueArray = new byte[valueSize];
                        in.readFully(valueArray);
                        values[i] = this.deserialize(valueArray);
                        continue;
                    }
                    values[i] = null;
                }
                this.consumerIDs = consumerIDs;
                this.keys = keys;
                this.values = values;
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        switch (this.getType()) {
            case 1: {
                break;
            }
            case 2: {
                byte[] serializedValue = this.serialize(this.serverInfo);
                out.writeInt(serializedValue.length);
                out.write(serializedValue);
                break;
            }
            case 3: {
                out.writeLong(this.changeConsumerID);
                out.writeInt(this.nodeParents.length);
                for (int i = 0; i < this.nodeParents.length; ++i) {
                    out.writeString(this.nodeParents[i]);
                }
                out.writeString(this.nodeName);
                if (null != this.nodeValue) {
                    byte[] serializedValue = this.serialize(this.nodeValue);
                    out.writeInt(serializedValue.length);
                    out.write(serializedValue);
                    break;
                }
                out.writeInt(0);
                break;
            }
            case 4: {
                out.writeLong(this.changeConsumerID);
                out.writeInt(this.nodeParents.length);
                for (int i = 0; i < this.nodeParents.length; ++i) {
                    out.writeString(this.nodeParents[i]);
                }
                out.writeString(this.nodeName);
                break;
            }
            case 5: {
                out.writeInt(this.consumerIDs.length);
                for (int i = 0; i < this.consumerIDs.length; ++i) {
                    out.writeLong(this.consumerIDs[i]);
                    out.writeString(this.keys[i]);
                    if (null != this.values[i]) {
                        byte[] serializedValue = this.serialize(this.values[i]);
                        out.writeInt(serializedValue.length);
                        out.write(serializedValue);
                        continue;
                    }
                    out.writeInt(0);
                }
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    public long getConsumerID() {
        return this.changeConsumerID;
    }

    public String[] getParents() {
        return this.nodeParents;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Serializable getNodeValue() {
        return this.nodeValue;
    }

    public Serializable getServerInfo() {
        return this.serverInfo;
    }

    public long[] getConsumerIDs() {
        return this.consumerIDs;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public Serializable[] getValues() {
        return this.values;
    }

    private byte[] serialize(Serializable value) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] result = null;
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(value);
            objectStream.close();
            result = byteStream.toByteArray();
        }
        catch (IOException e) {
            Assert.fail();
        }
        return result;
    }

    private Serializable deserialize(byte[] valueArray) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(valueArray);
        Serializable object = null;
        try {
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            object = (Serializable)objectStream.readObject();
        }
        catch (IOException e) {
            Assert.fail();
        }
        catch (ClassNotFoundException e) {
            Assert.fail();
        }
        return object;
    }
}

