/*
 * Decompiled with CFR 0.152.
 */
package com.tc.cluster;

import com.tc.cluster.ClusterTopology;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tcclient.cluster.Node;
import com.tcclient.cluster.NodeImpl;
import com.tcclient.cluster.NodeInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClusterTopologyImpl
implements ClusterTopology {
    private final ConcurrentMap<NodeID, NodeInternal> nodes = new ConcurrentHashMap<NodeID, NodeInternal>();
    private final ReentrantReadWriteLock nodesLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock nodesReadLock = this.nodesLock.readLock();
    private final ReentrantReadWriteLock.WriteLock nodesWriteLock = this.nodesLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<NodeInternal> getInternalNodes() {
        this.nodesReadLock.lock();
        try {
            Collection<NodeInternal> collection = Collections.unmodifiableCollection(new ArrayList(this.nodes.values()));
            return collection;
        }
        finally {
            this.nodesReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeInternal getInternalNode(NodeID nodeId) {
        this.nodesReadLock.lock();
        try {
            NodeInternal nodeInternal = (NodeInternal)this.nodes.get(nodeId);
            return nodeInternal;
        }
        finally {
            this.nodesReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Node> getNodes() {
        this.nodesReadLock.lock();
        try {
            Collection<Node> collection = Collections.unmodifiableCollection(new ArrayList(this.nodes.values()));
            return collection;
        }
        finally {
            this.nodesReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsNode(NodeID nodeId) {
        this.nodesReadLock.lock();
        try {
            boolean bl = this.nodes.containsKey(nodeId);
            return bl;
        }
        finally {
            this.nodesReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeInternal getAndRegisterNode(ClientID nodeId) {
        this.nodesReadLock.lock();
        try {
            NodeInternal node = (NodeInternal)this.nodes.get(nodeId);
            if (node != null) {
                NodeInternal nodeInternal = node;
                return nodeInternal;
            }
        }
        finally {
            this.nodesReadLock.unlock();
        }
        return this.registerNode(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeInternal getAndRemoveNode(NodeID nodeId) {
        this.nodesWriteLock.lock();
        try {
            NodeInternal node;
            NodeInternal nodeInternal = node = (NodeInternal)this.nodes.remove(nodeId);
            return nodeInternal;
        }
        finally {
            this.nodesWriteLock.unlock();
        }
    }

    NodeInternal registerNode(ClientID nodeId) {
        return this.registerNodeBase(nodeId, false);
    }

    NodeInternal registerThisNode(ClientID nodeId) {
        return this.registerNodeBase(nodeId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeInternal updateOnRejoin(ClientID thisNodeId, NodeID[] clusterMembers) {
        this.nodesWriteLock.lock();
        try {
            for (NodeID otherNode : clusterMembers) {
                if (thisNodeId.equals(otherNode)) continue;
                this.registerNodeBase((ClientID)otherNode, false);
            }
            NodeInternal nodeInternal = this.registerNodeBase(thisNodeId, true);
            return nodeInternal;
        }
        finally {
            this.nodesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeInternal registerNodeBase(ClientID clientId, boolean isLocalNode) {
        NodeImpl node = new NodeImpl(clientId.toString(), clientId.toLong());
        this.nodesWriteLock.lock();
        try {
            NodeInternal old = this.nodes.putIfAbsent(clientId, node);
            if (old != null) {
                NodeInternal nodeInternal = old;
                return nodeInternal;
            }
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            this.nodesWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        this.nodesWriteLock.lock();
        try {
            this.nodes.clear();
        }
        finally {
            this.nodesWriteLock.unlock();
        }
    }
}

