/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding.fields;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.terracotta.runnel.decoding.fields.AbstractField;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.metadata.Metadata;
import org.terracotta.runnel.utils.ReadBuffer;

public class StructField
extends AbstractField {
    private final List<? extends Field> subFields;
    private final Metadata metadata;

    public StructField(String name, int index, List<? extends Field> subFields) {
        this(name, index, subFields, true);
    }

    public StructField(String name, int index, List<? extends Field> subFields, boolean init) {
        super(name, index);
        this.subFields = subFields;
        this.metadata = new Metadata(subFields, init);
    }

    public void init() {
        this.metadata.init();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public List<? extends Field> subFields() {
        return this.subFields;
    }

    @Override
    public void dump(ReadBuffer parentBuffer, PrintStream out, int depth) {
        int fieldSize = parentBuffer.getVlqInt();
        out.append(" size: ").append(Integer.toString(fieldSize));
        ReadBuffer readBuffer = parentBuffer.limit(fieldSize);
        out.append(" type: ").append(this.getClass().getSimpleName());
        out.append(" name: ").append(this.name());
        Map<Integer, Field> fieldsByInteger = this.getMetadata().buildFieldsByIndexMap();
        while (!readBuffer.limitReached()) {
            out.append("\n  ");
            for (int j = 0; j < depth; ++j) {
                out.append("  ");
            }
            int index = readBuffer.getVlqInt();
            out.append(" index: ").append(Integer.toString(index));
            Field subField = fieldsByInteger.get(index);
            subField.dump(readBuffer, out, depth + 1);
        }
    }
}

