/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.inet.HostAndIpValidator;

class SettingValidator {
    private static final String MULTI_VALUE_SEP = ",";
    private static final String PARAM_INTERNAL_SEP = ":";
    static final BiConsumer<String, Tuple2<String, String>> DEFAULT_VALIDATOR = (setting, kv) -> {
        Setting s = Setting.fromName(setting);
        Objects.requireNonNull(kv);
        SettingValidator.requireNull(s, (String)kv.t1);
        if (s.mustBePresent() && !s.allows(Operation.UNSET) && (kv.t2 == null || ((String)kv.t2).trim().isEmpty())) {
            throw new IllegalArgumentException(s + " cannot be null or empty");
        }
        if (kv.t2 != null && !((String)kv.t2).isEmpty() && ((String)kv.t2).trim().isEmpty()) {
            throw new IllegalArgumentException(s + " cannot be null or empty");
        }
        if (kv.t2 != null && !((String)kv.t2).isEmpty() && !s.allowsValue((String)kv.t2)) {
            throw new IllegalArgumentException(s + " should be one of: " + s.getAllowedValues());
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> NAME_VALIDATOR = (setting, kv) -> {
        DEFAULT_VALIDATOR.accept((String)setting, (Tuple2<String, String>)kv);
        if (Substitutor.containsSubstitutionParams((String)kv.t2)) {
            throw new IllegalArgumentException(setting + " cannot contain substitution parameters");
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> TIME_VALIDATOR = (setting, kv) -> {
        DEFAULT_VALIDATOR.accept((String)setting, (Tuple2<String, String>)kv);
        if (kv.t2 != null) {
            Setting s = Setting.fromName(setting);
            Measure.parse((String)kv.t2, TimeUnit.class, s.getAllowedUnits());
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> PORT_VALIDATOR = (setting, kv) -> {
        DEFAULT_VALIDATOR.accept((String)setting, (Tuple2<String, String>)kv);
        if (kv.t2 != null && !Substitutor.containsSubstitutionParams((String)kv.t2)) {
            int port;
            try {
                port = Integer.parseInt((String)kv.t2);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("<port> specified in " + setting + "=<port> must be an integer between 1 and 65535");
            }
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("<port> specified in " + setting + "=<port> must be an integer between 1 and 65535");
            }
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> PATH_VALIDATOR = (setting, kv) -> {
        DEFAULT_VALIDATOR.accept((String)setting, (Tuple2<String, String>)kv);
        if (kv.t2 != null && !Substitutor.containsSubstitutionParams((String)kv.t2)) {
            try {
                Paths.get((String)kv.t2, new String[0]);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid path specified for setting " + setting + ": " + (String)kv.t2);
            }
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> ADDRESS_VALIDATOR = (setting, kv) -> {
        DEFAULT_VALIDATOR.accept((String)setting, (Tuple2<String, String>)kv);
        if (!(kv.t2 == null || Substitutor.containsSubstitutionParams((String)kv.t2) || HostAndIpValidator.isValidIPv4((String)kv.t2) || HostAndIpValidator.isValidIPv6((String)kv.t2))) {
            throw new IllegalArgumentException("<address> specified in " + setting + "=<address> must be a valid IP address");
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> HOST_VALIDATOR = (setting, kv) -> {
        DEFAULT_VALIDATOR.accept((String)setting, (Tuple2<String, String>)kv);
        String hostname = (String)kv.t2;
        if (!(kv.t2 == null || Substitutor.containsSubstitutionParams((String)kv.t2) || HostAndIpValidator.isValidIPv4(hostname) || HostAndIpValidator.isValidIPv6(hostname) || HostAndIpValidator.isValidHost(hostname))) {
            throw new IllegalArgumentException("<address> specified in " + setting + "=<address> must be a valid hostname or IP address");
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> OFFHEAP_VALIDATOR = (setting, kv) -> {
        if (kv.t2 != null && !((String)kv.t2).isEmpty()) {
            SettingValidator.validateMappings(kv, setting + " should be specified in the format <resource-name>:<quantity><unit>,<resource-name>:<quantity><unit>...", (k, v) -> {
                try {
                    Measure.parse(v, MemoryUnit.class, Setting.fromName(setting).getAllowedUnits());
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException(setting + "." + k + " is invalid: " + e.getMessage());
                }
            });
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> DATA_DIRS_VALIDATOR = (setting, kv) -> {
        if (kv.t2 != null && !((String)kv.t2).isEmpty()) {
            SettingValidator.validatePathMappings(kv, setting + " should be specified in the format <resource-name>:<path>,<resource-name>:<path>...", (k, v) -> {
                if (!Substitutor.containsSubstitutionParams(v)) {
                    try {
                        Paths.get(v, new String[0]);
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(setting + "." + k + " is invalid: Bad path: " + v);
                    }
                }
            });
        }
    };
    private static final Set<String> LEGAL_LOGGER_LEVELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF")));
    static final BiConsumer<String, Tuple2<String, String>> LOGGER_LEVEL_VALIDATOR = (setting, kv) -> {
        if (kv.t2 != null && !((String)kv.t2).isEmpty()) {
            SettingValidator.validateMappings(kv, setting + " should be specified in the format <logger>:<level>,<logger>:<level>...", (k, v) -> {
                if (!LEGAL_LOGGER_LEVELS.contains(v.toUpperCase(Locale.ROOT))) {
                    throw new IllegalArgumentException(setting + "." + k + " is invalid: Bad level: " + v);
                }
            });
        }
    };
    static final BiConsumer<String, Tuple2<String, String>> PROPS_VALIDATOR = (setting, kv) -> {
        if (kv.t2 != null && !((String)kv.t2).isEmpty()) {
            SettingValidator.validateMappings(kv, setting + " should be specified in the format <key>:<value>,<key>:<value>...", (k, v) -> {});
        }
    };

    SettingValidator() {
    }

    private static void validateMappings(Tuple2<String, String> kv, String err, BiConsumer<String, String> valueValidator) {
        String[] mappings;
        String value = kv.t1 == null ? (String)kv.t2 : (String)kv.t1 + PARAM_INTERNAL_SEP + (String)kv.t2;
        for (String mapping : mappings = value.split(MULTI_VALUE_SEP)) {
            String[] split = mapping.split(PARAM_INTERNAL_SEP);
            if (split.length != 2 || split[0] == null || split[1] == null || split[0].trim().isEmpty() || split[1].trim().isEmpty()) {
                throw new IllegalArgumentException(err);
            }
            valueValidator.accept(split[0], split[1]);
        }
    }

    private static void validatePathMappings(Tuple2<String, String> kv, String err, BiConsumer<String, String> valueValidator) {
        String[] mappings;
        String value = kv.t1 == null ? (String)kv.t2 : (String)kv.t1 + PARAM_INTERNAL_SEP + (String)kv.t2;
        for (String mapping : mappings = value.split(MULTI_VALUE_SEP)) {
            String[] split = mapping.split(PARAM_INTERNAL_SEP);
            if (split.length < 2 || split[0] == null || split[1] == null || split[0].trim().isEmpty() || split[1].trim().isEmpty()) {
                throw new IllegalArgumentException(err);
            }
            valueValidator.accept(split[0], split[1]);
        }
    }

    private static void requireNull(Setting setting, String key) {
        if (!setting.isMap() && key != null) {
            throw new IllegalArgumentException(setting + " is not a map");
        }
    }
}

