/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;

public interface ConnectionService {
    public boolean handlesURI(URI var1);

    default public boolean handlesConnectionType(String connectionType) {
        return true;
    }

    public Connection connect(URI var1, Properties var2) throws ConnectionException;

    default public Connection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        StringBuilder b = new StringBuilder("terracotta://");
        for (InetSocketAddress a : servers) {
            b.append(a.getHostString());
            b.append(':');
            b.append(a.getPort());
            b.append(',');
        }
        try {
            if (b.length() > 0) {
                return this.connect(new URI(b.substring(0, b.length() - 1)), properties);
            }
            throw new ConnectionException(new IOException("no servers specified"));
        }
        catch (URISyntaxException u) {
            throw new ConnectionException(u);
        }
    }
}

