/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.util.Assert;
import java.io.IOException;

public class EntityDescriptor
implements TCSerializable<EntityDescriptor> {
    public static final long INVALID_VERSION = 0L;
    public static final EntityDescriptor NULL_ID = new EntityDescriptor(EntityID.NULL_ID, 0L);
    private final FetchID fetchID;
    private final EntityID entityID;
    private final ClientInstanceID clientInstanceID;
    private final long clientSideVersion;

    public static EntityDescriptor createDescriptorForLifecycle(EntityID entityID, long clientSideVersion) {
        return new EntityDescriptor(entityID, clientSideVersion);
    }

    public static EntityDescriptor createDescriptorForFetch(EntityID entityID, long clientSideVersion, ClientInstanceID instance) {
        return new EntityDescriptor(entityID, clientSideVersion, instance);
    }

    public static EntityDescriptor createDescriptorForInvoke(FetchID fetchID, ClientInstanceID clientInstanceID) {
        return new EntityDescriptor(fetchID, clientInstanceID);
    }

    private EntityDescriptor(EntityID entityID, long clientSideVersion) {
        this.fetchID = FetchID.NULL_ID;
        this.entityID = entityID;
        this.clientInstanceID = ClientInstanceID.NULL_ID;
        this.clientSideVersion = clientSideVersion;
    }

    private EntityDescriptor(EntityID entityID, long clientSideVersion, ClientInstanceID instance) {
        this.fetchID = FetchID.NULL_ID;
        this.entityID = entityID;
        this.clientInstanceID = instance;
        this.clientSideVersion = clientSideVersion;
    }

    private EntityDescriptor(FetchID fetchID, ClientInstanceID clientInstanceID) {
        this.fetchID = fetchID;
        this.entityID = EntityID.NULL_ID;
        this.clientInstanceID = clientInstanceID;
        this.clientSideVersion = -1L;
    }

    public boolean isIndexed() {
        return !this.fetchID.isNull();
    }

    public FetchID getFetchID() {
        Assert.assertTrue(this.isIndexed());
        return this.fetchID;
    }

    public EntityID getEntityID() {
        Assert.assertFalse(this.isIndexed());
        return this.entityID;
    }

    public ClientInstanceID getClientInstanceID() {
        return this.clientInstanceID;
    }

    public long getClientSideVersion() {
        return this.clientSideVersion;
    }

    public int hashCode() {
        Assert.assertFalse(this.isIndexed());
        return this.entityID.hashCode() ^ this.clientInstanceID.hashCode();
    }

    public boolean equals(Object other) {
        boolean doesMatch;
        Assert.assertFalse(this.isIndexed());
        boolean bl = doesMatch = this == other;
        if (!doesMatch && this.getClass() == other.getClass()) {
            EntityDescriptor that = (EntityDescriptor)other;
            doesMatch = this.entityID.equals(that.entityID) && this.clientInstanceID.equals(that.clientInstanceID);
        }
        return doesMatch;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeLong(this.fetchID.toLong());
        if (this.fetchID.isNull()) {
            this.entityID.serializeTo(serialOutput);
            serialOutput.writeLong(this.clientSideVersion);
        }
        this.clientInstanceID.serializeTo(serialOutput);
    }

    @Override
    public EntityDescriptor deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        return EntityDescriptor.readFrom(serialInput);
    }

    public static EntityDescriptor readFrom(TCByteBufferInput serialInput) throws IOException {
        long fetchID = serialInput.readLong();
        if (fetchID == FetchID.NULL_ID.toLong()) {
            return new EntityDescriptor(EntityID.readFrom(serialInput), serialInput.readLong(), ClientInstanceID.readFrom(serialInput));
        }
        return new EntityDescriptor(new FetchID(fetchID), ClientInstanceID.readFrom(serialInput));
    }

    public String toString() {
        if (this.fetchID.isNull()) {
            return "EntityDescriptor{entityID=" + this.entityID + ", version=" + this.clientSideVersion + ", instance=" + this.clientInstanceID + "}";
        }
        return "EntityDescriptor{fetchID=" + this.fetchID + ", instance=" + this.clientInstanceID + "}";
    }
}

