/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core.event;

import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.Collection;
import org.slf4j.Logger;

public class TCConnectionEventCaller {
    private static final int CONNECT = 1;
    private static final int EOF = 2;
    private static final int ERROR = 3;
    private static final int CLOSE = 4;
    private final SetOnceFlag connectEvent = new SetOnceFlag();
    private final SetOnceFlag eofEvent = new SetOnceFlag();
    private final SetOnceFlag errorEvent = new SetOnceFlag();
    private final SetOnceFlag closeEvent = new SetOnceFlag();
    private final Logger logger;

    public TCConnectionEventCaller(Logger logger) {
        this.logger = logger;
    }

    public void fireErrorEvent(Collection<TCConnectionEventListener> eventListeners, TCConnection conn, Exception exception, TCNetworkMessage context) {
        if (this.errorEvent.attemptSet()) {
            TCConnectionErrorEvent event = new TCConnectionErrorEvent(conn, exception, context);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 3);
        }
    }

    public void fireConnectEvent(Collection<TCConnectionEventListener> eventListeners, TCConnection conn) {
        if (this.connectEvent.attemptSet()) {
            TCConnectionEvent event = new TCConnectionEvent(conn);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 1);
        }
    }

    public void fireEndOfFileEvent(Collection<TCConnectionEventListener> eventListeners, TCConnection conn) {
        if (this.eofEvent.attemptSet()) {
            TCConnectionEvent event = new TCConnectionEvent(conn);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 2);
        }
    }

    public void fireCloseEvent(Collection<TCConnectionEventListener> eventListeners, TCConnection conn) {
        if (this.closeEvent.attemptSet()) {
            TCConnectionEvent event = new TCConnectionEvent(conn);
            TCConnectionEventCaller.fireEvent(eventListeners, event, this.logger, 4);
        }
    }

    private static void fireEvent(Collection<TCConnectionEventListener> eventListeners, TCConnectionEvent event, Logger logger, int type) {
        for (TCConnectionEventListener listener : eventListeners) {
            try {
                switch (type) {
                    case 1: {
                        listener.connectEvent(event);
                        break;
                    }
                    case 2: {
                        listener.endOfFileEvent(event);
                        break;
                    }
                    case 3: {
                        listener.errorEvent((TCConnectionErrorEvent)event);
                        break;
                    }
                    case 4: {
                        listener.closeEvent(event);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown event type: " + type));
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unhandled exception in event handler", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

