/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.utilities.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import org.ehcache.shadow.org.terracotta.utilities.io.NullOutputStream;

public abstract class CapturedPrintStream
extends PrintStream {
    volatile PrintStream delegate;

    private CapturedPrintStream(PrintStream delegate) throws UnsupportedEncodingException {
        super((OutputStream)new NullOutputStream(), false, StandardCharsets.UTF_8.name());
        this.delegate = delegate;
    }

    public static CapturedPrintStream getInstance(Path filePath, boolean autoFlush) throws IOException {
        FileOutputStream fos = FileCapturedPrintStream.open(Objects.requireNonNull(filePath, "filePath"), new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND});
        try {
            return new FileCapturedPrintStream(filePath, fos, autoFlush);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Unexpected exception creating CapturedPrintStream", e);
        }
    }

    public static CapturedPrintStream getInstance(Path filePath) throws IOException {
        return CapturedPrintStream.getInstance(filePath, true);
    }

    public static CapturedPrintStream getInstance() {
        try {
            return new MemoryCapturedPrintStream(new LocalBufferedOutputStream(4096));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Unexpected exception creating CapturedPrintStream", e);
        }
    }

    final void swapDelegate(PrintStream newDelegate) {
        this.delegate.flush();
        this.delegate.close();
        this.delegate = newDelegate;
    }

    public abstract BufferedReader getReader();

    public abstract void reset();

    public abstract byte[] toByteArray();

    @Override
    public synchronized void flush() {
        this.delegate.flush();
    }

    @Override
    public synchronized void close() {
        this.delegate.close();
    }

    @Override
    public synchronized boolean checkError() {
        return this.delegate.checkError();
    }

    @Override
    public synchronized void write(int b) {
        this.delegate.write(b);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) {
        this.delegate.write(buf, off, len);
    }

    @Override
    public synchronized void print(boolean b) {
        this.delegate.print(b);
    }

    @Override
    public synchronized void print(char c) {
        this.delegate.print(c);
    }

    @Override
    public synchronized void print(int i) {
        this.delegate.print(i);
    }

    @Override
    public synchronized void print(long l) {
        this.delegate.print(l);
    }

    @Override
    public synchronized void print(float f) {
        this.delegate.print(f);
    }

    @Override
    public synchronized void print(double d) {
        this.delegate.print(d);
    }

    @Override
    public synchronized void print(char[] s) {
        this.delegate.print(s);
    }

    @Override
    public synchronized void print(String s) {
        this.delegate.print(s);
    }

    @Override
    public synchronized void print(Object obj) {
        this.delegate.print(obj);
    }

    @Override
    public synchronized void println() {
        this.delegate.println();
    }

    @Override
    public synchronized void println(boolean x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(char x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(int x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(long x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(float x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(double x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(char[] x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(String x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized void println(Object x) {
        this.delegate.println(x);
    }

    @Override
    public synchronized PrintStream printf(String format, Object ... args) {
        this.delegate.printf(format, args);
        return this;
    }

    @Override
    public synchronized PrintStream printf(Locale l, String format, Object ... args) {
        this.delegate.printf(l, format, args);
        return this;
    }

    @Override
    public synchronized PrintStream format(String format, Object ... args) {
        this.delegate.format(format, args);
        return this;
    }

    @Override
    public synchronized PrintStream format(Locale l, String format, Object ... args) {
        this.delegate.format(l, format, args);
        return this;
    }

    @Override
    public synchronized PrintStream append(CharSequence csq) {
        this.delegate.append(csq);
        return this;
    }

    @Override
    public synchronized PrintStream append(CharSequence csq, int start, int end) {
        this.delegate.append(csq, start, end);
        return this;
    }

    @Override
    public synchronized PrintStream append(char c) {
        this.delegate.append(c);
        return this;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    private static final class LocalBufferedOutputStream
    extends BufferedOutputStream {
        LocalBufferedOutputStream(int size) {
            super(new ByteArrayOutputStream(size), size);
        }

        void reset() {
            ((ByteArrayOutputStream)this.out).reset();
        }

        byte[] toByteArray() {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
    }

    public static final class MemoryCapturedPrintStream
    extends CapturedPrintStream {
        private final LocalBufferedOutputStream out;

        private MemoryCapturedPrintStream(LocalBufferedOutputStream out) throws UnsupportedEncodingException {
            super(new PrintStream((OutputStream)out, false, StandardCharsets.UTF_8.name()));
            this.out = out;
        }

        @Override
        public synchronized BufferedReader getReader() {
            return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.toByteArray()), StandardCharsets.UTF_8), 4096);
        }

        @Override
        public synchronized void reset() {
            this.flush();
            this.out.reset();
        }

        @Override
        public synchronized byte[] toByteArray() {
            this.flush();
            return this.out.toByteArray();
        }
    }

    public static final class FileCapturedPrintStream
    extends CapturedPrintStream {
        private final Path filePath;
        private final boolean autoFlush;
        private volatile FileDescriptor fd;

        private FileCapturedPrintStream(Path filePath, FileOutputStream fileOutputStream, boolean autoFlush) throws IOException {
            super(new PrintStream((OutputStream)new BufferedOutputStream(fileOutputStream, 4096), autoFlush, StandardCharsets.UTF_8.name()));
            this.filePath = filePath;
            this.autoFlush = autoFlush;
            this.fd = fileOutputStream.getFD();
        }

        private static FileOutputStream open(Path filePath, OpenOption ... options) throws IOException {
            HashSet<OpenOption> specifiedOptions = new HashSet<OpenOption>(Arrays.asList(options));
            if (specifiedOptions.contains(StandardOpenOption.CREATE)) {
                try {
                    Files.createFile(filePath, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    // empty catch block
                }
            }
            boolean append = !specifiedOptions.contains(StandardOpenOption.TRUNCATE_EXISTING);
            return new FileOutputStream(filePath.toFile(), append);
        }

        public void sync() throws IOException {
            this.flush();
            this.fd.sync();
        }

        @Override
        public synchronized BufferedReader getReader() {
            try {
                this.flush();
                this.fd.sync();
                return Files.newBufferedReader(this.filePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public synchronized void reset() {
            try {
                FileOutputStream fos = FileCapturedPrintStream.open(this.filePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                this.swapDelegate(new PrintStream((OutputStream)new BufferedOutputStream(fos, 4096), this.autoFlush, StandardCharsets.UTF_8.name()));
                this.fd = fos.getFD();
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError("Unexpected exception creating file buffer for CapturedPrintStream", e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public synchronized byte[] toByteArray() {
            try {
                this.flush();
                this.fd.sync();
                return Files.readAllBytes(this.filePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

