/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store.operations;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.PutWithWriterOperation;
import org.ehcache.clustered.common.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.TimestampOperation;
import org.ehcache.spi.serialization.Serializer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OperationCode {
    PUT(1){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new PutOperation<K, V>(buffer, keySerializer, valueSerializer);
        }

        @Override
        public boolean shouldBePinned() {
            return false;
        }
    }
    ,
    REMOVE(2){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new RemoveOperation(buffer, keySerializer);
        }
    }
    ,
    PUT_IF_ABSENT(3){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new PutIfAbsentOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REMOVE_CONDITIONAL(4){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new ConditionalRemoveOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REPLACE(5){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new ReplaceOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REPLACE_CONDITIONAL(6){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new ConditionalReplaceOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    PUT_WITH_WRITER(7){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new PutWithWriterOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    TIMESTAMP(8){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new TimestampOperation(buffer, keySerializer);
        }
    };

    private final byte value;

    private OperationCode(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean shouldBePinned() {
        return true;
    }

    public abstract <K, V> Operation<K, V> decode(ByteBuffer var1, Serializer<K> var2, Serializer<V> var3);

    public static OperationCode valueOf(byte value) {
        switch (value) {
            case 1: {
                return PUT;
            }
            case 2: {
                return REMOVE;
            }
            case 3: {
                return PUT_IF_ABSENT;
            }
            case 4: {
                return REMOVE_CONDITIONAL;
            }
            case 5: {
                return REPLACE;
            }
            case 6: {
                return REPLACE_CONDITIONAL;
            }
            case 7: {
                return PUT_WITH_WRITER;
            }
            case 8: {
                return TIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Operation undefined for the value " + value);
    }
}

