/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.inet;

import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class HostAndIpValidator {
    private static final Pattern OCTET = Pattern.compile("(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])");
    private static final Pattern IPv4_ADDRESS = Pattern.compile("(?:" + OCTET + "\\.){3}" + OCTET);
    private static final Pattern IPv4_MASK = Pattern.compile("(?:3[0-2]|2[0-9]|1[0-9]|[0-9])");
    private static final Pattern IPv6_MASK = Pattern.compile("(?:[0-9]|[1-9][0-9]|1[0-1][0-9]|12[0-8])");
    private static final String IPv4_CIDR = IPv4_ADDRESS + "/" + IPv4_MASK;
    private static final String IPv4_CIDR_SUFFIX = "/32";
    private static final String IPv6_CIDR_SUFFIX = "/128";

    public static boolean isValidHost(String host) {
        try {
            return !IDN.toASCII(host, 3).isEmpty();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidIPv4(String ipAddress) {
        return IPv4_ADDRESS.matcher(ipAddress).matches();
    }

    public static boolean isValidIPv4Cidr(String cidr) {
        return cidr.matches(IPv4_CIDR);
    }

    public static boolean isValidIPv6(String ipAddress) {
        if (ipAddress.startsWith("[")) {
            try {
                InetAddress.getAllByName(ipAddress);
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return HostAndIpValidator.isValidIPv6("[" + ipAddress + "]");
    }

    public static boolean isValidIPv6(String ipAddress, boolean brackets) {
        if (brackets) {
            if (ipAddress.startsWith("[")) {
                try {
                    InetAddress.getAllByName(ipAddress);
                    return true;
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
            return false;
        }
        return HostAndIpValidator.isValidIPv6("[" + ipAddress + "]", true);
    }

    public static boolean isValidIPv6Cidr(String cidr) {
        String[] parts = cidr.split("/", 2);
        if (parts.length == 2) {
            return HostAndIpValidator.isValidIPv6(parts[0]) && IPv6_MASK.matcher(parts[1]).matches();
        }
        return false;
    }

    public static String getIPv4Suffix() {
        return IPv4_CIDR_SUFFIX;
    }

    public static String getIPv6Suffix() {
        return IPv6_CIDR_SUFFIX;
    }
}

