/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.inet.HostPort;

public class Identifier {
    private final String identifier;

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    private Identifier(String identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public static Identifier valueOf(String identifier) {
        return new Identifier(identifier);
    }

    public Optional<? extends PropertyHolder> findObject(Cluster cluster, Scope type) {
        HostPort hostPort;
        UID uid;
        try {
            uid = UID.valueOf(this.identifier);
        }
        catch (RuntimeException e) {
            uid = null;
        }
        try {
            hostPort = HostPort.parse(this.identifier, 9410);
        }
        catch (RuntimeException e) {
            hostPort = null;
        }
        switch (type) {
            case NODE: {
                return this.findNode(cluster.getNodes(), uid, hostPort);
            }
            case STRIPE: {
                return this.findStripe(cluster.getStripes(), uid, hostPort);
            }
            case CLUSTER: {
                return this.identifier.equals(cluster.getName()) || cluster.getUID().equals(uid) || this.findStripe(cluster.getStripes(), uid, hostPort).isPresent() ? Optional.of(cluster) : Optional.empty();
            }
        }
        throw new AssertionError((Object)type);
    }

    private Optional<Stripe> findStripe(Collection<Stripe> stripes, UID uid, HostPort hostPort) {
        for (Stripe stripe : stripes) {
            if (!stripe.getName().equals(this.identifier) && !stripe.getUID().equals(uid)) continue;
            return Optional.of(stripe);
        }
        for (Stripe stripe : stripes) {
            Optional<Node> node = this.findNode(stripe.getNodes(), uid, hostPort);
            if (!node.isPresent()) continue;
            return Optional.of(stripe);
        }
        return Optional.empty();
    }

    private Optional<Node> findNode(Collection<Node> nodes, UID uid, HostPort hostPort) {
        for (Node node : nodes) {
            if (!node.getName().equals(this.identifier) && !node.getUID().equals(uid) && !node.getInternalHostPort().equals(hostPort) && (!node.getPublicHostPort().isPresent() || !node.getPublicHostPort().get().equals(hostPort))) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }
}

