/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Objects;

public class LockContext {
    private static final String DELIMITER = ";";
    private final String token;
    private final String ownerName;
    private final String ownerTags;

    private LockContext() {
        this(null, null, null);
    }

    public LockContext(String token, String ownerName, String ownerTags) {
        this.token = token;
        this.ownerName = ownerName;
        this.ownerTags = ownerTags;
    }

    public String getToken() {
        return this.token;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerTags() {
        return this.ownerTags;
    }

    public static LockContext from(String contextStr) {
        String[] substrings = contextStr.split(DELIMITER);
        if (substrings.length != 3) {
            throw new IllegalArgumentException(String.format("Invalid lock-context '%s', expected format 'uuid;owner-name;owner-tags", contextStr));
        }
        return new LockContext(substrings[0], substrings[1], substrings[2]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockContext that = (LockContext)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.ownerName, that.ownerName) && Objects.equals(this.ownerTags, that.ownerTags);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.ownerName, this.ownerTags);
    }

    public String toString() {
        return String.format("%s%s%s%s%s", this.token, DELIMITER, this.ownerName, DELIMITER, this.ownerTags);
    }

    public String ownerInfo() {
        return String.format("%s (%s)", this.ownerName, this.ownerTags);
    }
}

