/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.request;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityResponse;
import com.tc.object.request.RequestResponseHandler;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;

public class RequestReceiveHandler
extends AbstractEventHandler<VoltronEntityResponse> {
    private final RequestResponseHandler handler;

    public RequestReceiveHandler(RequestResponseHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleEvent(VoltronEntityResponse response) throws EventHandlerException {
        TransactionID transactionID = response.getTransactionID();
        if (!transactionID.isNull()) {
            switch (response.getAckType()) {
                case RETIRED: {
                    this.handler.retired(transactionID);
                    break;
                }
                case COMPLETED: {
                    VoltronEntityAppliedResponse appliedResponse = (VoltronEntityAppliedResponse)response;
                    Exception failureException = appliedResponse.getFailureException();
                    if (failureException != null) {
                        this.handler.failed(transactionID, failureException);
                    } else {
                        this.handler.complete(transactionID, appliedResponse.getSuccessValue());
                    }
                    this.handler.retired(transactionID);
                    break;
                }
                case RECEIVED: {
                    this.handler.received(transactionID);
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
        }
    }
}

