/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.transport.TypeOfService;
import com.tc.net.protocol.transport.WireProtocolHeaderFormatException;
import com.tc.util.Assert;
import com.tc.util.Conversion;

public class WireProtocolHeader
extends AbstractTCNetworkHeader
implements Cloneable {
    public static final byte VERSION_1 = 1;
    public static final byte VERSION_2 = 2;
    private static final byte[] VALID_VERSIONS = new byte[]{1, 2};
    public static final short DEFAULT_TTL = 64;
    public static final int MAX_MESSAGE_COUNT = 65535;
    public static final short PROTOCOL_UNKNOWN = 0;
    public static final short PROTOCOL_TCM = 1;
    public static final short PROTOCOL_TRANSPORT_HANDSHAKE = 2;
    public static final short PROTOCOL_OOOP = 3;
    public static final short PROTOCOL_HEALTHCHECK_PROBES = 4;
    public static final short PROTOCOL_MSGGROUP = 5;
    private static final int MAGIC_NUM = -1431655766;
    private static final short[] VALID_PROTOCOLS = new short[]{1, 2, 3, 4, 5};
    static final short MAX_LENGTH = 60;
    static final short MIN_LENGTH = 32;

    public static short getProtocolForMessageClass(TCNetworkMessage msg) {
        if (msg.getHeader() instanceof TCMessageHeader) {
            return 1;
        }
        return 0;
    }

    public WireProtocolHeader() {
        super(32, 60);
        this.setMagicNum(-1431655766);
        this.setVersion((byte)2);
        this.setHeaderLength((short)8);
        this.setTimeToLive((short)64);
        this.setTypeOfService(TypeOfService.DEFAULT_TOS.getByteValue());
    }

    public WireProtocolHeader(TCByteBuffer buffer) {
        super(buffer, 32, 60);
    }

    private void setMagicNum(int magic_num2) {
        this.data.putInt(4, -1431655766);
    }

    public void setVersion(byte version) {
        if (version <= 0 || version > 15) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this.set4BitValue(0, true, version);
    }

    @Override
    protected void setHeaderLength(short length) {
        if (length < 6 || length > 15) {
            throw new IllegalArgumentException("Header length must in range 6-15");
        }
        this.set4BitValue(0, false, (byte)length);
    }

    public void setTypeOfService(short tos) {
        this.data.putUbyte(1, tos);
    }

    public void setTimeToLive(short ttl) {
        this.data.putUbyte(2, ttl);
    }

    public void setProtocol(short protocol) {
        this.data.putUbyte(3, protocol);
    }

    public void setTotalPacketLength(int length) {
        this.data.putInt(8, length);
    }

    public void setSourceAddress(byte[] srcAddr) {
        this.data.put(16, srcAddr, 0, 4);
    }

    public void setDestinationAddress(byte[] destAddr) {
        this.data.put(20, destAddr, 0, 4);
    }

    public void setSourcePort(int srcPort) {
        this.data.putUshort(24, srcPort);
    }

    public void setDestinationPort(int dstPort) {
        this.data.putUshort(26, dstPort);
    }

    public void setMessageCount(int count) {
        Assert.eval(count <= 65535);
        this.data.putUshort(28, count);
    }

    public int getMessageCount() {
        return this.data.getUshort(28);
    }

    public int getMagicNum() {
        return this.data.getInt(4);
    }

    public byte getVersion() {
        return this.get4BitValue(0, true);
    }

    public byte getHeaderLength() {
        return this.get4BitValue(0, false);
    }

    public short getTypeOfService() {
        return this.data.getUbyte(1);
    }

    public short getTimeToLive() {
        return this.data.getUbyte(2);
    }

    public short getProtocol() {
        return this.data.getUbyte(3);
    }

    public int getTotalPacketLength() {
        return this.data.getInt(8);
    }

    public long getChecksum() {
        return this.data.getUint(12);
    }

    public byte[] getSourceAddress() {
        return this.getBytes(16, 4);
    }

    public byte[] getDestinationAddress() {
        return this.getBytes(20, 4);
    }

    public int getSourcePort() {
        return this.data.getUshort(24);
    }

    public int getDestinationPort() {
        return this.data.getUshort(26);
    }

    public void computeChecksum() {
        this.computeAdler32Checksum(12, true);
    }

    public void finalizeHeader(int totalLength) {
        this.setTotalPacketLength(totalLength);
        this.computeChecksum();
    }

    public boolean isChecksumValid() {
        return this.getChecksum() == this.computeAdler32Checksum(12, false);
    }

    @Override
    public void validate() throws WireProtocolHeaderFormatException {
        int magic = this.getMagicNum();
        if (magic != -1431655766) {
            throw new WireProtocolHeaderFormatException("Invalid magic number: " + magic + " != " + -1431655766);
        }
        boolean validVersion = false;
        byte version = this.getVersion();
        for (byte element : VALID_VERSIONS) {
            if (version != element) continue;
            validVersion = true;
            break;
        }
        if (!validVersion) {
            throw new WireProtocolHeaderFormatException("Bad Version: " + Conversion.byte2uint(version));
        }
        short ttl = this.getTimeToLive();
        if (0 == ttl) {
            throw new WireProtocolHeaderFormatException("TTL byte cannot be equal to zero");
        }
        boolean validProtocol = false;
        short protocol = this.getProtocol();
        for (short element : VALID_PROTOCOLS) {
            if (protocol != element) continue;
            validProtocol = true;
            break;
        }
        if (!validProtocol) {
            throw new WireProtocolHeaderFormatException("Bad Protocol byte: " + protocol);
        }
        int totalLength = this.getTotalPacketLength();
        if (totalLength < 32) {
            throw new WireProtocolHeaderFormatException("Total length (" + totalLength + ") can not be less than minimum header size (" + 32 + ")");
        }
        if (totalLength < this.getHeaderByteLength()) {
            throw new WireProtocolHeaderFormatException("Total length (" + totalLength + ") can not be less than actual header length (" + this.getHeaderByteLength() + ")");
        }
        if (!this.isChecksumValid()) {
            throw new WireProtocolHeaderFormatException(this.describe(false, "Invalid Checksum"));
        }
        if (this.getSourcePort() == 0) {
            throw new WireProtocolHeaderFormatException(this.describe(false, "Source port cannot be zero"));
        }
        if (this.getDestinationPort() == 0) {
            throw new WireProtocolHeaderFormatException(this.describe(false, "Destination port cannot be zero"));
        }
    }

    public String toString() {
        String errMsg = "no message";
        boolean valid = true;
        try {
            this.validate();
        }
        catch (WireProtocolHeaderFormatException e) {
            errMsg = e.getMessage();
            valid = false;
        }
        return this.describe(valid, errMsg);
    }

    private String describe(boolean valid, String errMsg) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("Version: ").append(Conversion.byte2uint(this.getVersion())).append(", ");
        buf.append("Header Length: ").append(Conversion.byte2uint(this.getHeaderLength())).append(", ");
        buf.append("TOS: ").append(this.getTypeOfService()).append(", ");
        buf.append("TTL: ").append(this.getTimeToLive()).append(", ");
        buf.append("Protocol: ").append(this.getProtocolString());
        buf.append("\n");
        buf.append("Total Packet Length: ").append(this.getTotalPacketLength()).append("\n");
        buf.append("Adler32 Checksum: ").append(this.getChecksum()).append(" (valid: ").append(this.isChecksumValid()).append(")\n");
        buf.append("Source Addresss: ");
        byte[] src = this.getSourceAddress();
        byte[] dest = this.getDestinationAddress();
        for (i = 0; i < src.length; ++i) {
            buf.append(Conversion.byte2uint(src[i]));
            if (i == src.length - 1) continue;
            buf.append(".");
        }
        buf.append("\n");
        buf.append("Destination Addresss: ");
        for (i = 0; i < dest.length; ++i) {
            buf.append(Conversion.byte2uint(dest[i]));
            if (i == dest.length - 1) continue;
            buf.append(".");
        }
        buf.append("\n");
        buf.append("Source Port: ").append(this.getSourcePort());
        buf.append(", Destination Port: ").append(this.getDestinationPort());
        buf.append("\n");
        buf.append("Total Msg Count: " + this.getMessageCount());
        buf.append("\n");
        buf.append("Header Validity: ").append(valid).append(" (").append(errMsg).append(")\n");
        return buf.toString();
    }

    private String getProtocolString() {
        short protocol = this.getProtocol();
        switch (protocol) {
            case 1: {
                return "TCM";
            }
            case 3: {
                return "OOOP";
            }
            case 4: {
                return "HEALTHCHECK_PROBES";
            }
            case 2: {
                return "TRANSPORT HANDSHAKE";
            }
            case 5: {
                return "TRANSPORT MSGGROUP";
            }
        }
        return "UNKNOWN (" + protocol + ")";
    }

    public int getMaxByteLength() {
        return 60;
    }

    public int getMinByteLength() {
        return 32;
    }

    @Override
    public int getHeaderByteLength() {
        return 4 * this.getHeaderLength();
    }

    public boolean isHandshakeOrHealthCheckMessage() {
        short proto = this.getProtocol();
        return proto == 2 || proto == 4;
    }

    public boolean isMessagesGrouped() {
        return 5 == this.getProtocol();
    }

    protected Object clone() {
        WireProtocolHeader rv = new WireProtocolHeader();
        rv.setVersion(this.getVersion());
        rv.setHeaderLength(this.getHeaderLength());
        rv.setTypeOfService(this.getTypeOfService());
        rv.setTimeToLive(this.getTimeToLive());
        rv.setProtocol(this.getProtocol());
        rv.setMagicNum(this.getMagicNum());
        rv.setTotalPacketLength(this.getTotalPacketLength());
        rv.computeChecksum();
        rv.setSourceAddress(this.getSourceAddress());
        rv.setDestinationAddress(this.getDestinationAddress());
        rv.setSourcePort(this.getSourcePort());
        rv.setDestinationPort(this.getDestinationPort());
        rv.setMessageCount(this.getMessageCount());
        return rv;
    }
}

