/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessageImpl;
import com.tc.net.protocol.tcm.TCActionNetworkMessage;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class TCActionNetworkMessageImpl
extends TCNetworkMessageImpl
implements TCActionNetworkMessage {
    private final Supplier<TCByteBuffer[]> payloadSupplier;
    private final AtomicReference<State> state = new AtomicReference<State>(State.PENDING);

    public TCActionNetworkMessageImpl(TCNetworkHeader header, Supplier<TCByteBuffer[]> payloadSupplier) {
        super(header);
        Objects.requireNonNull(payloadSupplier);
        this.payloadSupplier = payloadSupplier;
    }

    @Override
    public boolean load() {
        if (this.updateState(State.SEALED, EnumSet.of(State.PENDING))) {
            this.setPayload(this.payloadSupplier.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean commit() {
        return this.updateState(State.COMMITTED, EnumSet.of(State.SEALED));
    }

    @Override
    public boolean cancel() {
        return this.updateState(State.CANCELLED, EnumSet.of(State.PENDING, State.SEALED));
    }

    private boolean updateState(State to, EnumSet<State> ifCurrentIs) {
        return this.state.accumulateAndGet(to, (current, update) -> {
            if (ifCurrentIs.contains(current)) {
                return update;
            }
            return current;
        }) == to;
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == State.CANCELLED;
    }

    static enum State {
        PENDING,
        SEALED,
        COMMITTED,
        CANCELLED;

    }
}

