/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCReferenceSupport {
    private final Consumer<TCByteBuffer> returns;
    private final Collection<TCByteBuffer> items;
    private final AtomicInteger referenceCount = new AtomicInteger();
    private final MemoryTracker track;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCReferenceSupport.class);
    private static final Set<TCReferenceSupport> COMMITTED_REFERENCES = ConcurrentHashMap.newKeySet();
    private static volatile boolean TRACK_REFERENCES;

    private TCReferenceSupport(Collection<TCByteBuffer> tracked, Consumer<TCByteBuffer> returns) {
        this.items = tracked;
        this.returns = returns;
        this.track = TRACK_REFERENCES ? new MemoryTracker() : null;
    }

    public static void startMonitoringReferences() {
        TRACK_REFERENCES = true;
    }

    public static void stopMonitoringReferences() {
        TRACK_REFERENCES = false;
        COMMITTED_REFERENCES.clear();
    }

    public static int checkReferences() {
        return COMMITTED_REFERENCES.stream().map(TCReferenceSupport::gc).reduce(0, Integer::sum);
    }

    public static TCReference createReference(Collection<TCByteBuffer> tracked, Consumer<TCByteBuffer> returns) {
        if (returns == null) {
            returns = c -> {};
        }
        return new TCReferenceSupport(tracked, returns).reference();
    }

    private void reclaim() {
        Assert.assertTrue(this.referenceCount.get() == 0);
        for (TCByteBuffer buf : this.items) {
            this.returns.accept(buf.reInit());
        }
        COMMITTED_REFERENCES.remove(this);
    }

    private int gc() {
        if (this.track != null) {
            return this.track.gc();
        }
        return 0;
    }

    public static TCReference createGCReference(Collection<TCByteBuffer> tracked) {
        return new GCRef(tracked);
    }

    public static TCReference createGCReference(TCByteBuffer ... tracked) {
        return TCReferenceSupport.createGCReference(Arrays.asList(tracked));
    }

    public static TCReference createAggregateReference(Collection<TCReference> tracked) {
        return new RefRef(tracked);
    }

    public static TCReference createAggregateReference(TCReference ... tracked) {
        return TCReferenceSupport.createAggregateReference(Arrays.asList(tracked));
    }

    private Ref reference() {
        if (this.track != null) {
            COMMITTED_REFERENCES.add(this);
        }
        return new Ref(this.items, TCByteBuffer::asReadOnlyBuffer);
    }

    private static <T> Collector<? super T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    private class MemoryTracker {
        private final Map<Reference<? extends Ref>, Exception> outRefs = new ConcurrentHashMap<Reference<? extends Ref>, Exception>();
        private final ReferenceQueue<Ref> gcRefs = new ReferenceQueue();

        private MemoryTracker() {
        }

        private Reference<Ref> startTracking(Ref ref) {
            PhantomReference<Ref> tracker = new PhantomReference<Ref>(ref, this.gcRefs);
            Assert.assertNull(this.outRefs.put(tracker, new Exception()));
            return tracker;
        }

        private void stopTracking(Reference<Ref> ref) {
            Assert.assertNotNull(this.outRefs.remove(ref));
        }

        private int gc() {
            Reference<Ref> next = this.gcRefs.poll();
            int count = 0;
            while (next != null) {
                Exception stack = this.outRefs.remove(next);
                Assert.assertNotNull(stack);
                LOGGER.warn("memory reference found that was not properly closed. ", (Throwable)stack);
                if (TCReferenceSupport.this.referenceCount.decrementAndGet() == 0) {
                    TCReferenceSupport.this.reclaim();
                }
                next = this.gcRefs.poll();
                ++count;
            }
            return count;
        }
    }

    private class Ref
    implements TCReference {
        private final List<TCByteBuffer> localItems;
        private final Reference<Ref> tracker;
        private final SetOnceFlag closed = new SetOnceFlag();

        Ref(Collection<TCByteBuffer> localItems, Function<TCByteBuffer, TCByteBuffer> mapper) {
            TCReferenceSupport.this.referenceCount.getAndIncrement();
            this.tracker = TCReferenceSupport.this.track == null ? null : TCReferenceSupport.this.track.startTracking(this);
            this.localItems = (List)localItems.stream().map(mapper).filter(TCByteBuffer::hasRemaining).collect(TCReferenceSupport.toUnmodifiableList());
        }

        @Override
        public void close() {
            if (this.closed.attemptSet()) {
                if (TCReferenceSupport.this.track != null) {
                    TCReferenceSupport.this.track.stopTracking(this.tracker);
                }
                if (TCReferenceSupport.this.referenceCount.decrementAndGet() == 0) {
                    TCReferenceSupport.this.reclaim();
                }
            }
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            this.checkClosed();
            return this.localItems.iterator();
        }

        private void checkClosed() {
            if (this.closed.isSet()) {
                throw new IllegalStateException("reference is closed");
            }
        }

        @Override
        public Ref duplicate() {
            this.checkClosed();
            return new Ref(this.localItems, TCByteBuffer::slice);
        }

        @Override
        public Ref duplicate(int length) {
            this.checkClosed();
            int[] counter = new int[]{length};
            return new Ref(this.localItems, curs -> {
                curs = curs.slice();
                curs.limit(Math.min(counter[0], curs.capacity()));
                counter[0] = counter[0] - curs.remaining();
                return curs;
            });
        }
    }

    private static class RefRef
    implements TCReference {
        private final List<TCReference> localItems;

        RefRef(Collection<TCReference> run) {
            this.localItems = (List)run.stream().map(TCReference::duplicate).collect(TCReferenceSupport.toUnmodifiableList());
        }

        @Override
        public TCReference duplicate() {
            return new RefRef(this.localItems);
        }

        @Override
        public void close() {
            this.localItems.forEach(TCReference::close);
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            return this.localItems.stream().flatMap(r -> StreamSupport.stream(r.spliterator(), false)).iterator();
        }
    }

    private static class GCRef
    implements TCReference {
        private final List<TCByteBuffer> buffers;

        public GCRef(Collection<TCByteBuffer> buffers) {
            this.buffers = buffers.stream().filter(TCByteBuffer::hasRemaining).map(TCByteBuffer::slice).collect(Collectors.toList());
        }

        @Override
        public TCReference duplicate() {
            return new GCRef(this.buffers);
        }

        @Override
        public void close() {
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            return this.buffers.iterator();
        }
    }
}

