/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.exception.EntityBusyException;
import com.tc.exception.EntityReferencedException;
import com.tc.exception.ServerException;
import java.util.Arrays;
import java.util.LinkedList;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityServerException;
import org.terracotta.exception.EntityServerUncaughtException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class ExceptionUtils {
    public static void throwEntityException(Exception exp) throws EntityException {
        if (exp instanceof ConnectionClosedException) {
            throw ExceptionUtils.rewriteConnectionClosed((ConnectionClosedException)exp);
        }
        if (exp instanceof RuntimeException) {
            throw ExceptionUtils.addCallerStackTraceToRuntime((RuntimeException)exp);
        }
        Exception converted = ExceptionUtils.convert(exp);
        if (converted instanceof EntityException) {
            throw (EntityException)converted;
        }
        if (converted instanceof RuntimeException) {
            throw (RuntimeException)converted;
        }
        throw new RuntimeException(converted);
    }

    private static ConnectionClosedException rewriteConnectionClosed(ConnectionClosedException exp) {
        ConnectionClosedException local = exp.getClassName() != null ? new ConnectionClosedException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), !exp.messageWasNotSent(), exp) : new ConnectionClosedException(!exp.messageWasNotSent(), exp.getDescription(), exp);
        local.setStackTrace((StackTraceElement[])Arrays.asList(local.getStackTrace()).stream().filter(e -> !e.getClassName().equals(ExceptionUtils.class.getName())).toArray(StackTraceElement[]::new));
        return local;
    }

    private static RuntimeException addCallerStackTraceToRuntime(RuntimeException runtime) {
        LinkedList<StackTraceElement> newStack = new LinkedList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
        newStack.remove(0);
        newStack.removeIf(e -> e.getClassName().equals(ExceptionUtils.class.getName()));
        newStack.add(new StackTraceElement("##########  trace of exception cause", "starts here   ###########", null, -1));
        newStack.addAll(Arrays.asList(runtime.getStackTrace()));
        runtime.setStackTrace(newStack.toArray(new StackTraceElement[0]));
        return runtime;
    }

    public static Exception convert(Exception server) {
        if (server instanceof ServerException) {
            return ExceptionUtils.convertServerException((ServerException)server);
        }
        server.addSuppressed(new RuntimeException("caller local trace"));
        return server;
    }

    private static Exception convertServerException(ServerException exp) {
        switch (exp.getType()) {
            case CONNECTION_CLOSED: 
            case CONNECTION_SHUTDOWN: {
                return new ConnectionClosedException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), true, exp);
            }
            case ENTITY_ALREADY_EXISTS: {
                return new EntityAlreadyExistsException(exp.getClassName(), exp.getEntityName(), exp.getCause());
            }
            case ENTITY_BUSY_EXCEPTION: {
                return new EntityBusyException(exp.getClassName(), exp.getEntityName(), exp.getCause());
            }
            case ENTITY_CONFIGURATION: {
                return new EntityConfigurationException(exp.getClassName(), exp.getEntityName(), exp.getCause());
            }
            case ENTITY_NOT_FOUND: {
                return new EntityNotFoundException(exp.getClassName(), exp.getEntityName(), exp.getCause());
            }
            case ENTITY_NOT_PROVIDED: {
                return new EntityNotProvidedException(exp.getClassName(), exp.getEntityName(), exp.getCause());
            }
            case ENTITY_REFERENCED: {
                return new EntityReferencedException(exp.getClassName(), exp.getEntityName());
            }
            case ENTITY_SERVER: {
                return new EntityServerException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
            case ENTITY_SERVER_UNCAUGHT: {
                return new EntityServerUncaughtException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
            case ENTITY_USER_EXCEPTION: {
                return new EntityServerException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
            case ENTITY_VERSION_MISMATCH: {
                return new EntityVersionMismatchException(exp.getClassName(), exp.getEntityName(), 0L, 0L, exp.getCause());
            }
            case MESSAGE_CODEC: {
                return new EntityServerException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
            case PERMANENT_ENTITY: {
                return new PermanentEntityException(exp.getClassName(), exp.getEntityName(), exp.getCause());
            }
            case PERMISSION_DENIED: {
                return new EntityServerException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
            case RECONNECT_REJECTED: {
                return new EntityServerException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
            case WRAPPED_EXCEPTION: {
                return new EntityServerException(exp.getClassName(), exp.getEntityName(), exp.getDescription(), exp.getCause());
            }
        }
        return null;
    }
}

