/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class License {
    private final Map<String, Long> capabilities;
    private final LocalDate expiryDate;
    private final Map<String, Boolean> flags;

    private License() {
        this.capabilities = Collections.emptyMap();
        this.expiryDate = null;
        this.flags = Collections.emptyMap();
    }

    public License(Map<String, Long> capabilityLimitMap, LocalDate expiryDate) {
        this(capabilityLimitMap, Collections.emptyMap(), expiryDate);
    }

    public License(Map<String, Long> capabilityLimitMap, Map<String, Boolean> flagsMap, LocalDate expiryDate) {
        this.capabilities = Collections.unmodifiableMap(new HashMap<String, Long>(capabilityLimitMap));
        this.flags = Collections.unmodifiableMap(new HashMap<String, Boolean>(flagsMap));
        this.expiryDate = expiryDate;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public Map<String, Long> getCapabilities() {
        return this.capabilities;
    }

    public Map<String, Boolean> getFlags() {
        return this.flags;
    }

    public boolean hasCapability(String capability) {
        Long v = this.getLimit(capability);
        return v != null && v != 0L;
    }

    public Long getLimit(String capability) {
        return this.capabilities.get(capability);
    }

    public String getType() {
        return (String)this.flags.entrySet().stream().filter(Map.Entry::getValue).findFirst().get().getKey();
    }

    public String toString() {
        return "License{capabilities=" + this.capabilities + ", expiryDate=" + this.expiryDate + ", flagsMap=" + this.flags + "}";
    }

    public String toLoggingString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Type: ").append(this.getType()).append(System.lineSeparator());
        sb.append("Expiration: ").append(this.expiryDate == LocalDate.MAX ? "Never" : this.expiryDate).append(System.lineSeparator());
        sb.append("Capabilities:").append(System.lineSeparator());
        HashMap<String, Long> capabilities = new HashMap<String, Long>(this.capabilities);
        capabilities.remove("OffHeap");
        capabilities.forEach((k, v) -> sb.append(k + ": ").append(this.hasCapability((String)k)).append(System.lineSeparator()));
        sb.append("OffHeap: ").append(this.getLimit("OffHeap"));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return this.capabilities.equals(license.capabilities) && this.expiryDate.equals(license.expiryDate) && this.flags.equals(license.flags);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.expiryDate, this.flags);
    }
}

