/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class TCPropertyStore {
    private final Map<Key, String> props = new LinkedHashMap<Key, String>();

    public synchronized boolean containsKey(String key) {
        return this.props.containsKey(new Key(key));
    }

    public synchronized void setProperty(String key, String value) {
        Key k = new Key(key);
        this.props.remove(k);
        if (value != null) {
            this.props.put(k, value.trim());
        }
    }

    public synchronized String getProperty(String key) {
        return this.props.get(new Key(key));
    }

    public synchronized int size() {
        return this.props.size();
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public synchronized String[] keysArray() {
        String[] keys = new String[this.props.size()];
        int index = 0;
        for (Key key : this.props.keySet()) {
            keys[index++] = key.getKey();
        }
        return keys;
    }

    public synchronized void load(InputStream in) throws IOException {
        new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                TCPropertyStore.this.setProperty((String)key, (String)value);
                return null;
            }
        }.load(in);
    }

    public synchronized void putAll(TCPropertyStore other) {
        for (String key : other.keysArray()) {
            this.setProperty(key, other.getProperty(key));
        }
    }

    private static class Key {
        private final String key;

        Key(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.key.equalsIgnoreCase(other.key);
        }
    }
}

