/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.NodeID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;

public class ClusterMembershipMessage
extends DSOMessageBase {
    private static final byte EVENT_TYPE = 0;
    private static final byte NODE_ID = 1;
    private static final byte PRODUCT_ID = 2;
    private int eventType;
    private NodeID nodeID;
    private ProductID productId;

    public ClusterMembershipMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public ClusterMembershipMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBufferInputStream data) {
        super(sessionID, monitor, channel, header, data);
    }

    public void initialize(int type, NodeID nid, ProductID pid) {
        this.eventType = type;
        this.nodeID = nid;
        this.productId = pid;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.eventType);
        this.putNVPair((byte)1, this.nodeID);
        this.putNVPair((byte)2, this.productId.name());
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.eventType = this.getIntValue();
                return true;
            }
            case 1: {
                this.nodeID = this.getNodeIDValue();
                return true;
            }
            case 2: {
                this.productId = ProductID.valueOf(this.getStringValue());
                return true;
            }
        }
        return false;
    }

    public boolean isNodeConnectedEvent() {
        return EventType.isNodeConnected(this.eventType);
    }

    public boolean isNodeDisconnectedEvent() {
        return EventType.isNodeDisconnected(this.eventType);
    }

    public int getEventType() {
        return this.eventType;
    }

    public NodeID getNodeId() {
        return this.nodeID;
    }

    public ProductID getProductId() {
        return this.productId;
    }

    public static class EventType {
        public static final int NODE_CONNECTED = 0;
        public static final int NODE_DISCONNECTED = 1;

        public static boolean isValidType(int t) {
            return t >= 0 && t <= 1;
        }

        public static boolean isNodeConnected(int t) {
            return t == 0;
        }

        public static boolean isNodeDisconnected(int t) {
            return t == 1;
        }

        public static String toString(int eventType) {
            switch (eventType) {
                case 0: {
                    return "NODE_CONNECTED";
                }
                case 1: {
                    return "NODE_DISCONNECTED";
                }
            }
            return "UNKNOWN";
        }
    }
}

