/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Collection;

public enum Version {
    V1("1"),
    V2("2"),
    CURRENT("2");

    private final String value;

    private Version(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean amongst(Collection<Version> versions) {
        return versions.stream().anyMatch(this::is);
    }

    public boolean is(Version version) {
        return version.value.equals(this.value);
    }

    public static Version fromValue(String value) {
        for (Version version : Version.values()) {
            if (!version.value.equals(value)) continue;
            return version;
        }
        throw new IllegalArgumentException(value);
    }
}

