/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity.map.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.terracotta.entity.map.common.BooleanResponse;
import org.terracotta.entity.map.common.EntrySetResponse;
import org.terracotta.entity.map.common.KeySetResponse;
import org.terracotta.entity.map.common.MapResponse;
import org.terracotta.entity.map.common.MapValueResponse;
import org.terracotta.entity.map.common.NullResponse;
import org.terracotta.entity.map.common.SizeResponse;
import org.terracotta.entity.map.common.ValueCollectionResponse;

class ResponseCodec {
    ResponseCodec() {
    }

    public static MapResponse decode(byte[] bytes) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));
        byte type = input.readByte();
        switch (MapResponse.Type.values()[type]) {
            case NULL: {
                return NullResponse.readFrom(input);
            }
            case BOOLEAN: {
                return BooleanResponse.readFrom(input);
            }
            case SIZE: {
                return SizeResponse.readFrom(input);
            }
            case MAP_VALUE: {
                return MapValueResponse.readFrom(input);
            }
            case KEY_SET: {
                return KeySetResponse.readFrom(input);
            }
            case VALUE_COLLECTION: {
                return ValueCollectionResponse.readFrom(input);
            }
            case ENTRY_SET: {
                return EntrySetResponse.readFrom(input);
            }
        }
        throw new IllegalArgumentException("Unknown map response type " + type);
    }

    public static byte[] encode(MapResponse response) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(byteOut);
        output.writeByte(response.responseType().ordinal());
        response.writeTo(output);
        output.close();
        return byteOut.toByteArray();
    }
}

