/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.ehcache.ValueSupplier;
import org.ehcache.clustered.client.internal.store.ChainBuilder;
import org.ehcache.clustered.client.internal.store.ResolvedChain;
import org.ehcache.clustered.client.internal.store.operations.Operation;
import org.ehcache.clustered.client.internal.store.operations.PutOperation;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.client.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainResolver<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainResolver.class);
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private final OperationsCodec<K, V> codec;
    private final Expiry<? super K, ? super V> expiry;

    public ChainResolver(OperationsCodec<K, V> codec, Expiry<? super K, ? super V> expiry) {
        this.codec = codec;
        this.expiry = expiry;
    }

    public ResolvedChain<K, V> resolve(Chain chain, K key, long now) {
        Result<V> result = null;
        ChainBuilder chainBuilder = new ChainBuilder();
        long expirationTime = Long.MIN_VALUE;
        for (Element element : chain) {
            ByteBuffer payload = element.getPayload();
            Operation<K, V> operation = this.codec.decode(payload);
            final Result<V> previousResult = result;
            if (key.equals(operation.getKey())) {
                Duration duration;
                if ((result = operation.apply(result)) == null) continue;
                if (operation.isExpiryAvailable()) {
                    expirationTime = operation.expirationTime();
                    if (expirationTime == Long.MIN_VALUE || now < expirationTime) continue;
                    result = null;
                    continue;
                }
                try {
                    if (previousResult == null) {
                        duration = this.expiry.getExpiryForCreation(key, result.getValue());
                        if (duration == null) {
                            result = null;
                            continue;
                        }
                    } else {
                        duration = this.expiry.getExpiryForUpdate(key, new ValueSupplier<V>(){

                            public V value() {
                                return previousResult.getValue();
                            }
                        }, result.getValue());
                        if (duration == null) {
                            continue;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)ex);
                    duration = Duration.ZERO;
                }
                if (duration.isInfinite()) {
                    expirationTime = Long.MIN_VALUE;
                    continue;
                }
                long time = TIME_UNIT.convert(duration.getLength(), duration.getTimeUnit());
                expirationTime = time + operation.timeStamp();
                if (now < expirationTime) continue;
                result = null;
                continue;
            }
            payload.flip();
            chainBuilder = chainBuilder.add(payload);
        }
        if (result != null) {
            PutOperation resolvedOperation = new PutOperation(key, result.getValue(), -expirationTime);
            ByteBuffer payload = this.codec.encode(resolvedOperation);
            chainBuilder = chainBuilder.add(payload);
        }
        return new ResolvedChain.Impl(chainBuilder.build(), key, result);
    }
}

