/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.entity;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.locks.ClientLockManager;
import com.tc.object.locks.EntityLockID;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockLevel;
import org.terracotta.connection.entity.Entity;

public class MaintenanceModeService {
    private static TCLogger LOGGER = TCLogging.getLogger(MaintenanceModeService.class);
    private final ClientLockManager clientLockManager;

    public MaintenanceModeService(ClientLockManager clientLockManager) {
        this.clientLockManager = clientLockManager;
    }

    public <T extends Entity> void readLockEntity(Class<T> c, String name) {
        EntityLockID lockID = new EntityLockID(c.getName(), name);
        this.lock(lockID, LockLevel.READ);
    }

    public <T extends Entity> void readUnlockEntity(Class<T> c, String name) {
        EntityLockID lockID = new EntityLockID(c.getName(), name);
        this.unlock(lockID, LockLevel.READ);
    }

    public <T extends Entity> void enterMaintenanceMode(Class<T> c, String name) {
        EntityLockID lockID = new EntityLockID(c.getName(), name);
        this.lock(lockID, LockLevel.WRITE);
    }

    public <T extends Entity> boolean tryEnterMaintenanceMode(Class<T> c, String name) {
        EntityLockID lockID = new EntityLockID(c.getName(), name);
        return this.tryLock(lockID, LockLevel.WRITE);
    }

    public <T extends Entity> void exitMaintenanceMode(Class<T> c, String name) {
        EntityLockID lockID = new EntityLockID(c.getName(), name);
        this.unlock(lockID, LockLevel.WRITE);
    }

    private void lock(LockID id, LockLevel level) {
        long time = System.nanoTime();
        this.clientLockManager.lock(id, level);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("time to lock:" + id + " " + (Object)((Object)level) + " " + (System.nanoTime() - time) + " nanos");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock(LockID id, LockLevel level) {
        long time = System.nanoTime();
        try {
            boolean bl = this.clientLockManager.tryLock(id, level);
            return bl;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("time to try lock:" + id + " " + (Object)((Object)level) + " " + (System.nanoTime() - time) + " nanos");
            }
        }
    }

    private void unlock(LockID id, LockLevel level) {
        long time = System.nanoTime();
        this.clientLockManager.unlock(id, level);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("time to unlock:" + id + " " + (Object)((Object)level) + " " + (System.nanoTime() - time) + " nanos");
        }
    }
}

