/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.net.ClientID;
import com.tc.object.locks.ClientLock;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.GarbageLockException;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockLevel;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;

enum ClientGreediness {
    GARBAGE{

        @Override
        boolean canAward(LockLevel level) throws GarbageLockException {
            throw GarbageLockException.GARBAGE_LOCK_EXCEPTION;
        }

        @Override
        boolean isFree() {
            return true;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        boolean isGarbage() {
            return true;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) throws GarbageLockException {
            throw GarbageLockException.GARBAGE_LOCK_EXCEPTION;
        }

        @Override
        ClientGreediness awarded(ServerLockLevel level) throws GarbageLockException {
            throw GarbageLockException.GARBAGE_LOCK_EXCEPTION;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recallCommitted() {
            return this;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            throw new AssertionError((Object)"Garbage locks have no exchange context representation.");
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    FREE{

        @Override
        boolean canAward(LockLevel level) {
            return false;
        }

        @Override
        boolean isFree() {
            return true;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness awarded(ServerLockLevel level) {
            switch (level) {
                case READ: {
                    return GREEDY_READ;
                }
                case WRITE: {
                    return GREEDY_WRITE;
                }
            }
            throw new AssertionError((Object)("Trying to award unknown ServerLockLevel " + (Object)((Object)level)));
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return GARBAGE;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return null;
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    GREEDY_READ{

        @Override
        boolean canAward(LockLevel level) {
            return level.isRead();
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return true;
        }

        @Override
        boolean flushOnUnlock() {
            return false;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            switch (level) {
                case READ: {
                    return this;
                }
                case WRITE: {
                    return RECALLED_READ;
                }
            }
            throw new AssertionError((Object)("Trying to request unknown ServerLockLevel " + (Object)((Object)level)));
        }

        @Override
        ClientGreediness awarded(ServerLockLevel level) {
            switch (level) {
                case READ: {
                    return GREEDY_READ;
                }
                case WRITE: {
                    return GREEDY_WRITE;
                }
            }
            throw new AssertionError((Object)("Trying to award unknown ServerLockLevel " + (Object)((Object)level)));
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return RECALLED_READ;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_READ);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    GREEDY_WRITE{

        @Override
        boolean canAward(LockLevel level) {
            return true;
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return true;
        }

        @Override
        boolean flushOnUnlock() {
            return false;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            if (lease > 0 && clientLock.pendingCount() > 0) {
                return GREEDY_WRITE;
            }
            switch (level) {
                case READ: {
                    return RECALLED_WRITE_FOR_READ;
                }
                case WRITE: {
                    return RECALLED_WRITE;
                }
            }
            throw new AssertionError((Object)("Trying to recall for unknown ServerLockLevel " + (Object)((Object)level)));
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_WRITE);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    RECALLED_READ{

        @Override
        boolean canAward(LockLevel level) {
            return false;
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return true;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recallInProgress() {
            return READ_RECALL_IN_PROGRESS;
        }

        @Override
        ClientGreediness recallCommitted() {
            return FREE;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_READ);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    RECALLED_WRITE{

        @Override
        boolean canAward(LockLevel level) {
            return false;
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return true;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return this;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        ClientGreediness recallInProgress() {
            return WRITE_RECALL_IN_PROGRESS;
        }

        @Override
        ClientGreediness recallCommitted() {
            return FREE;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_WRITE);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    READ_RECALL_IN_PROGRESS{

        @Override
        boolean canAward(LockLevel level) {
            return false;
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return true;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recallCommitted() {
            return FREE;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_READ);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    WRITE_RECALL_IN_PROGRESS{

        @Override
        boolean canAward(LockLevel level) {
            return false;
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return true;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recallCommitted() {
            return FREE;
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_WRITE);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.WRITE;
        }
    }
    ,
    RECALLED_WRITE_FOR_READ{

        @Override
        boolean canAward(LockLevel level) {
            return level.isRead();
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return true;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return false;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness recallInProgress() {
            return WRITE_RECALL_FOR_READ_IN_PROGRESS;
        }

        @Override
        ClientGreediness recallCommitted() {
            return GREEDY_READ;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            switch (level) {
                case READ: {
                    return this;
                }
                case WRITE: {
                    return RECALLED_WRITE;
                }
            }
            throw new AssertionError((Object)("Trying to recall for unknown ServerLockLevel " + (Object)((Object)level)));
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_WRITE);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.READ;
        }
    }
    ,
    WRITE_RECALL_FOR_READ_IN_PROGRESS{

        @Override
        boolean canAward(LockLevel level) {
            return level.isRead();
        }

        @Override
        boolean isFree() {
            return false;
        }

        @Override
        boolean isRecalled() {
            return false;
        }

        @Override
        boolean isGreedy() {
            return false;
        }

        @Override
        boolean flushOnUnlock() {
            return true;
        }

        @Override
        boolean isRecallInProgress() {
            return true;
        }

        @Override
        boolean isGarbage() {
            return false;
        }

        @Override
        ClientGreediness recallCommitted() {
            return GREEDY_READ;
        }

        @Override
        ClientGreediness requested(ServerLockLevel level) {
            return this;
        }

        @Override
        ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
            switch (level) {
                case READ: {
                    return this;
                }
                case WRITE: {
                    return WRITE_RECALL_IN_PROGRESS;
                }
            }
            throw new AssertionError((Object)("Trying to recall for unknown ServerLockLevel " + (Object)((Object)level)));
        }

        @Override
        ClientGreediness markAsGarbage() {
            return this;
        }

        @Override
        ClientServerExchangeLockContext toContext(LockID lock, ClientID client) {
            return new ClientServerExchangeLockContext(lock, client, ThreadID.VM_ID, ServerLockContext.State.GREEDY_HOLDER_WRITE);
        }

        @Override
        public ServerLockLevel getFlushLevel() {
            return ServerLockLevel.READ;
        }
    };


    abstract boolean canAward(LockLevel var1) throws GarbageLockException;

    abstract boolean isFree();

    abstract boolean isRecalled();

    abstract boolean isGreedy();

    abstract boolean flushOnUnlock();

    abstract boolean isRecallInProgress();

    abstract boolean isGarbage();

    abstract ServerLockLevel getFlushLevel();

    ClientGreediness requested(ServerLockLevel level) throws GarbageLockException {
        throw new AssertionError((Object)("request level while in unexpected state (" + (Object)((Object)this) + ")"));
    }

    ClientGreediness awarded(ServerLockLevel level) throws GarbageLockException {
        throw new AssertionError((Object)("award while in unexpected state (" + (Object)((Object)this) + ")"));
    }

    ClientGreediness recalled(ClientLock clientLock, int lease, ServerLockLevel level) {
        throw new AssertionError((Object)("recalled while in unexpected state (" + (Object)((Object)this) + ")"));
    }

    ClientGreediness recallInProgress() {
        throw new AssertionError((Object)("recall in progress while in unexpected state (" + (Object)((Object)this) + ")"));
    }

    ClientGreediness recallCommitted() {
        throw new AssertionError((Object)("recall committed while in unexpected state (" + (Object)((Object)this) + ")"));
    }

    ClientGreediness markAsGarbage() {
        throw new AssertionError((Object)("marking as garbage while in unexpected state (" + (Object)((Object)this) + ")"));
    }

    abstract ClientServerExchangeLockContext toContext(LockID var1, ClientID var2);
}

