/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.PostInit;
import com.tc.async.api.SEDA;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.cluster.Cluster;
import com.tc.entity.NetworkVoltronEntityMessageImpl;
import com.tc.entity.ServerEntityMessageImpl;
import com.tc.entity.ServerEntityResponseMessageImpl;
import com.tc.entity.VoltronEntityAppliedResponseImpl;
import com.tc.entity.VoltronEntityReceivedResponseImpl;
import com.tc.entity.VoltronEntityResponse;
import com.tc.entity.VoltronEntityRetiredResponseImpl;
import com.tc.exception.TCRuntimeException;
import com.tc.handler.CallbackDumpAdapter;
import com.tc.handler.CallbackDumpHandler;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.CallbackOnExitState;
import com.tc.logging.ClientIDLogger;
import com.tc.logging.ClientIDLoggerProvider;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.TCClient;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OOONetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.HydrateHandler;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageMonitorImpl;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.HealthCheckerConfigClientImpl;
import com.tc.net.protocol.transport.NullConnectionPolicy;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientNameProvider;
import com.tc.object.ClientShutdownManager;
import com.tc.object.StandardClientBuilder;
import com.tc.object.config.ClientConfig;
import com.tc.object.config.ConnectionInfoConfig;
import com.tc.object.config.PreparedComponentsFromL2Connection;
import com.tc.object.context.PauseContext;
import com.tc.object.handler.ClientCoordinationHandler;
import com.tc.object.handler.ClusterInternalEventsHandler;
import com.tc.object.handler.ClusterMembershipEventsHandler;
import com.tc.object.handler.LockResponseHandler;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.handshakemanager.ClientHandshakeManagerImpl;
import com.tc.object.locks.ClientLockManager;
import com.tc.object.locks.ClientLockManagerConfigImpl;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.msg.ClientHandshakeAckMessageImpl;
import com.tc.object.msg.ClientHandshakeMessageImpl;
import com.tc.object.msg.ClientHandshakeRefusedMessageImpl;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.msg.InvokeRegisteredServiceMessage;
import com.tc.object.msg.InvokeRegisteredServiceResponseMessage;
import com.tc.object.msg.ListRegisteredServicesMessage;
import com.tc.object.msg.ListRegisteredServicesResponseMessage;
import com.tc.object.msg.LockRequestMessage;
import com.tc.object.msg.LockResponseMessage;
import com.tc.object.request.RequestReceiveHandler;
import com.tc.object.servermessage.ServerMessageReceiveHandler;
import com.tc.object.session.SessionManagerImpl;
import com.tc.operatorevent.TerracottaOperatorEventLogging;
import com.tc.platform.rejoin.ClientChannelEventController;
import com.tc.properties.ReconnectConfig;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.runtime.TCMemoryManagerImpl;
import com.tc.runtime.logging.LongGCLogger;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.stats.counter.sampled.derived.SampledRateCounterConfig;
import com.tc.text.PrettyPrintable;
import com.tc.util.Assert;
import com.tc.util.CommonShutDownHook;
import com.tc.util.ProductID;
import com.tc.util.ProductInfo;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.concurrent.Runners;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.TaskRunner;
import com.tc.util.runtime.LockInfoByThreadID;
import com.tc.util.runtime.LockState;
import com.tc.util.runtime.ThreadIDManager;
import com.tc.util.runtime.ThreadIDManagerImpl;
import com.tc.util.runtime.ThreadIDMap;
import com.tc.util.runtime.ThreadIDMapImpl;
import com.tc.util.sequence.Sequence;
import com.tc.util.sequence.SimpleSequence;
import com.tcclient.cluster.ClusterInternal;
import com.tcclient.cluster.ClusterInternalEventsContext;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DistributedObjectClient
implements TCClient {
    protected static final TCLogger DSO_LOGGER = CustomerLogging.getDSOGenericLogger();
    private static final TCLogger CONSOLE_LOGGER = CustomerLogging.getConsoleLogger();
    private static final int MAX_CONNECT_TRIES = -1;
    private static final String L1VMShutdownHookName = "L1 VM Shutdown Hook";
    private final ClientBuilder clientBuilder;
    private final ClientConfig config;
    private final ClusterInternal cluster;
    private final TCThreadGroup threadGroup;
    private final ThreadIDMap threadIDMap;
    protected final PreparedComponentsFromL2Connection connectionComponents;
    private final ProductID productId;
    private ClientMessageChannel channel;
    private ClientLockManager lockManager;
    private CommunicationsManager communicationsManager;
    private ClientHandshakeManager clientHandshakeManager;
    private CounterManager counterManager;
    private ThreadIDManager threadIDManager;
    private final CallbackDumpHandler dumpHandler = new CallbackDumpHandler();
    private TCMemoryManagerImpl tcMemManager;
    private Stage<ClusterInternalEventsContext> clusterEventsStage;
    private final TCSecurityManager securityManager;
    private final String uuid;
    private final String name;
    private final TaskRunner taskRunner;
    private ClientShutdownManager shutdownManager;
    private final Thread shutdownAction;
    private final SetOnceFlag clientStopped = new SetOnceFlag();
    private final SetOnceFlag connectionMade = new SetOnceFlag();
    private ClientEntityManager clientEntityManager;
    private final StageManager communicationStageManager;

    public DistributedObjectClient(ClientConfig config, TCThreadGroup threadGroup, PreparedComponentsFromL2Connection connectionComponents, ClusterInternal cluster) {
        this(config, threadGroup, connectionComponents, cluster, null, UUID.NULL_ID.toString(), "", null);
    }

    public DistributedObjectClient(ClientConfig config, TCThreadGroup threadGroup, PreparedComponentsFromL2Connection connectionComponents, ClusterInternal cluster, TCSecurityManager securityManager, String uuid, String name, ProductID productId) {
        this.productId = productId;
        Assert.assertNotNull(config);
        this.config = config;
        this.securityManager = securityManager;
        this.connectionComponents = connectionComponents;
        this.cluster = cluster;
        this.threadGroup = threadGroup;
        this.threadIDMap = new ThreadIDMapImpl();
        this.clientBuilder = this.createClientBuilder();
        this.uuid = uuid;
        this.name = name;
        this.taskRunner = Runners.newDefaultCachedScheduledTaskRunner(threadGroup);
        this.shutdownAction = new Thread((Runnable)new ShutdownAction(), L1VMShutdownHookName);
        Runtime.getRuntime().addShutdownHook(this.shutdownAction);
        SEDA seda = new SEDA(threadGroup);
        this.communicationStageManager = seda.getStageManager();
        this.tcMemManager = new TCMemoryManagerImpl(threadGroup);
    }

    protected ClientBuilder createClientBuilder() {
        return new StandardClientBuilder();
    }

    @Override
    public ThreadIDMap getThreadIDMap() {
        return this.threadIDMap;
    }

    @Override
    public void addAllLocksTo(LockInfoByThreadID lockInfo) {
        if (this.lockManager != null) {
            block5: for (ClientServerExchangeLockContext c : this.lockManager.getAllLockContexts()) {
                switch (c.getState().getType()) {
                    case GREEDY_HOLDER: 
                    case HOLDER: {
                        lockInfo.addLock(LockState.HOLDING, c.getThreadID(), c.getLockID().toString());
                        continue block5;
                    }
                    case WAITER: {
                        lockInfo.addLock(LockState.WAITING_ON, c.getThreadID(), c.getLockID().toString());
                        continue block5;
                    }
                    case TRY_PENDING: 
                    case PENDING: {
                        lockInfo.addLock(LockState.WAITING_TO, c.getThreadID(), c.getLockID().toString());
                        continue block5;
                    }
                }
                throw new AssertionError((Object)c.getState().getType());
            }
        } else {
            DSO_LOGGER.error("LockManager not initialised still. LockInfo for threads cannot be updated");
        }
    }

    private void validateSecurityConfig() {
        if (this.config.getSecurityInfo().isSecure() && this.securityManager == null) {
            throw new TCRuntimeException("client configured as secure but was constructed without securityManager");
        }
        if (!this.config.getSecurityInfo().isSecure() && this.securityManager != null) {
            throw new TCRuntimeException("client not configured as secure but was constructed with securityManager");
        }
    }

    private ReconnectConfig getReconnectPropertiesFromServer() {
        ReconnectConfig reconnectConfig = new ReconnectConfig(){

            @Override
            public boolean getReconnectEnabled() {
                return true;
            }

            @Override
            public int getReconnectTimeout() {
                return 5000;
            }

            @Override
            public int getSendQueueCapacity() {
                return 5000;
            }

            @Override
            public int getMaxDelayAcks() {
                return 16;
            }

            @Override
            public int getSendWindow() {
                return 32;
            }
        };
        return reconnectConfig;
    }

    private NetworkStackHarnessFactory getNetworkStackHarnessFactory(boolean useOOOLayer, ReconnectConfig l1ReconnectConfig) {
        if (useOOOLayer) {
            return new OOONetworkStackHarnessFactory(new OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl(), l1ReconnectConfig);
        }
        return new PlainNetworkStackHarnessFactory();
    }

    public Stage<ClusterInternalEventsContext> getClusterEventsStage() {
        return this.clusterEventsStage;
    }

    public synchronized void start() {
        this.validateSecurityConfig();
        TCProperties tcProperties = TCPropertiesImpl.getProperties();
        int maxSize = tcProperties.getInt("l1.seda.stage.sink.capacity");
        SessionManagerImpl sessionManager = new SessionManagerImpl(new SessionManagerImpl.SequenceFactory(){

            @Override
            public Sequence newSequence() {
                return new SimpleSequence();
            }
        });
        this.threadGroup.addCallbackOnExitDefaultHandler(new CallbackOnExitHandler(){

            @Override
            public void callbackOnExit(CallbackOnExitState state) {
                DistributedObjectClient.this.cluster.fireNodeError();
            }
        });
        this.dumpHandler.registerForDump(new CallbackDumpAdapter(this.communicationStageManager));
        ReconnectConfig l1ReconnectConfig = this.getReconnectPropertiesFromServer();
        boolean useOOOLayer = l1ReconnectConfig.getReconnectEnabled();
        NetworkStackHarnessFactory networkStackHarnessFactory = this.getNetworkStackHarnessFactory(useOOOLayer, l1ReconnectConfig);
        this.counterManager = new CounterManagerImpl();
        MessageMonitor mm = MessageMonitorImpl.createMonitor(tcProperties, DSO_LOGGER);
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        this.communicationsManager = this.clientBuilder.createCommunicationsManager(mm, messageRouter, networkStackHarnessFactory, new NullConnectionPolicy(), this.connectionComponents.createConnectionInfoConfigItemByGroup().length, new HealthCheckerConfigClientImpl(tcProperties.getPropertiesFor("l1.healthcheck.l2"), "DSO Client"), this.getMessageTypeClassMapping(), ReconnectionRejectedHandlerL1.SINGLETON, this.securityManager, this.productId);
        DSO_LOGGER.debug("Created CommunicationsManager.");
        ConnectionInfoConfig[] connectionInfoItems = this.connectionComponents.createConnectionInfoConfigItemByGroup();
        ConnectionInfo[] connectionInfo = connectionInfoItems[0].getConnectionInfos();
        final String serverHost = connectionInfo[0].getHostname();
        final int serverPort = connectionInfo[0].getPort();
        this.clusterEventsStage = this.communicationStageManager.createStage("cluster_events_stage", ClusterInternalEventsContext.class, new ClusterInternalEventsHandler(this.cluster), 1, maxSize);
        int socketConnectTimeout = tcProperties.getInt("l1.socket.connect.timeout");
        if (socketConnectTimeout < 0) {
            throw new IllegalArgumentException("invalid socket time value: " + socketConnectTimeout);
        }
        this.channel = this.clientBuilder.createClientMessageChannel(this.communicationsManager, this.connectionComponents, sessionManager, -1, socketConnectTimeout, this);
        ClientIDLoggerProvider cidLoggerProvider = new ClientIDLoggerProvider(this.channel);
        this.communicationStageManager.setLoggerProvider(cidLoggerProvider);
        DSO_LOGGER.debug("Created channel.");
        this.clientEntityManager = this.clientBuilder.createClientEntityManager(this.channel, this.communicationStageManager);
        RequestReceiveHandler receivingHandler = new RequestReceiveHandler(this.clientEntityManager);
        Stage<VoltronEntityResponse> entityResponseStage = this.communicationStageManager.createStage("request_ack_stage", VoltronEntityResponse.class, receivingHandler, 1, maxSize);
        Stage<Void> serverMessageStage = this.communicationStageManager.createStage("server_entity_message_stage", Void.class, new ServerMessageReceiveHandler(this.channel), 1, maxSize);
        TerracottaOperatorEventLogging.setNodeNameProvider(new ClientNameProvider(this.cluster));
        SampledRateCounterConfig sampledRateCounterConfig = new SampledRateCounterConfig(1, 300, true);
        this.counterManager.createCounter(sampledRateCounterConfig);
        this.counterManager.createCounter(sampledRateCounterConfig);
        SampledCounterConfig sampledCounterConfig = new SampledCounterConfig(1, 300, true, 0L);
        this.counterManager.createCounter(sampledCounterConfig);
        this.threadGroup.addCallbackOnExitDefaultHandler(new CallbackDumpAdapter(this.clientEntityManager));
        this.dumpHandler.registerForDump(new CallbackDumpAdapter(this.clientEntityManager));
        long timeOut = TCPropertiesImpl.getProperties().getLong("logging.longgc.threshold");
        LongGCLogger gcLogger = this.clientBuilder.createLongGCLogger(timeOut);
        this.tcMemManager.registerForMemoryEvents(gcLogger);
        this.tcMemManager.checkGarbageCollectors();
        this.threadIDManager = new ThreadIDManagerImpl(this.threadIDMap);
        this.lockManager = this.clientBuilder.createLockManager(this.channel, new ClientIDLogger(this.channel, TCLogging.getLogger(ClientLockManager.class)), sessionManager, this.channel.getLockRequestMessageFactory(), this.threadIDManager, new ClientLockManagerConfigImpl(tcProperties.getPropertiesFor("l1.lockmanager")), this.taskRunner);
        CallbackDumpAdapter lockDumpAdapter = new CallbackDumpAdapter(this.lockManager);
        this.threadGroup.addCallbackOnExitDefaultHandler(lockDumpAdapter);
        this.dumpHandler.registerForDump(lockDumpAdapter);
        Stage<Void> lockResponse = this.communicationStageManager.createStage("lock_response_stage", Void.class, new LockResponseHandler(sessionManager), 1, maxSize);
        Stage<HydrateContext> hydrateStage = this.communicationStageManager.createStage("hydrate_message_stage", HydrateContext.class, new HydrateHandler(), 1, maxSize);
        Stage<PauseContext> pauseStage = this.communicationStageManager.createStage("client_coordination_stage", PauseContext.class, new ClientCoordinationHandler(), 1, maxSize);
        Sink<PauseContext> pauseSink = pauseStage.getSink();
        Stage<Void> clusterMembershipEventStage = this.communicationStageManager.createStage("cluster_membership_event_stage", Void.class, new ClusterMembershipEventsHandler(this.cluster), 1, maxSize);
        ArrayList<PrettyPrintable> clientHandshakeCallbacks = new ArrayList<PrettyPrintable>();
        clientHandshakeCallbacks.add(this.lockManager);
        clientHandshakeCallbacks.add(this.clientEntityManager);
        ProductInfo pInfo = ProductInfo.getInstance();
        this.clientHandshakeManager = this.clientBuilder.createClientHandshakeManager(new ClientIDLogger(this.channel, TCLogging.getLogger(ClientHandshakeManagerImpl.class)), this.channel.getClientHandshakeMessageFactory(), pauseSink, sessionManager, this.cluster, this.uuid, this.name, pInfo.version(), Collections.unmodifiableCollection(clientHandshakeCallbacks));
        ClientChannelEventController.connectChannelEventListener(this.channel, pauseSink, this.clientHandshakeManager);
        this.shutdownManager = new ClientShutdownManager(this, this.connectionComponents);
        ClientConfigurationContext cc = new ClientConfigurationContext(this.communicationStageManager, this.lockManager, this.clientEntityManager, this.clientHandshakeManager);
        this.communicationStageManager.startAll(cc, Collections.<PostInit>emptyList(), new String[0]);
        this.initChannelMessageRouter(messageRouter, hydrateStage.getSink(), lockResponse.getSink(), pauseSink, clusterMembershipEventStage.getSink(), entityResponseStage.getSink(), serverMessageStage.getSink());
        new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                while (!DistributedObjectClient.this.clientStopped.isSet()) {
                    try {
                        DistributedObjectClient.this.openChannel(serverHost, serverPort);
                        DistributedObjectClient.this.waitForHandshake();
                        DistributedObjectClient.this.connectionMade();
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }, "Connection Establisher - " + this.uuid).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionMade() {
        this.connectionMade.attemptSet();
        SetOnceFlag setOnceFlag = this.connectionMade;
        synchronized (setOnceFlag) {
            this.connectionMade.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForConnection(long timeout, TimeUnit units) throws InterruptedException {
        SetOnceFlag setOnceFlag = this.connectionMade;
        synchronized (setOnceFlag) {
            long start;
            for (long left = timeout > 0L ? units.toMillis(timeout) : Long.MAX_VALUE; !this.connectionMade.isSet() && left > 0L; left -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                this.connectionMade.wait(units.toMillis(timeout));
            }
        }
        return this.connectionMade.isSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChannel(String serverHost, int serverPort) throws InterruptedException {
        SetOnceFlag setOnceFlag = this.clientStopped;
        synchronized (setOnceFlag) {
            while (!this.clientStopped.isSet()) {
                try {
                    char[] pw;
                    DSO_LOGGER.debug("Trying to open channel....");
                    if (this.config.getSecurityInfo().hasCredentials()) {
                        Assert.assertNotNull(this.securityManager);
                        pw = this.securityManager.getPasswordForTC(this.config.getSecurityInfo().getUsername(), serverHost, serverPort);
                    } else {
                        pw = null;
                    }
                    this.channel.open(pw);
                    DSO_LOGGER.debug("Channel open");
                    break;
                }
                catch (TCTimeoutException tcte) {
                    CONSOLE_LOGGER.warn("Timeout connecting to server: " + tcte.getMessage());
                    this.clientStopped.wait(5000L);
                }
                catch (ConnectException e) {
                    CONSOLE_LOGGER.warn("Connection refused from server: " + e);
                    this.clientStopped.wait(5000L);
                }
                catch (MaxConnectionsExceededException e) {
                    DSO_LOGGER.fatal(e.getMessage());
                    CONSOLE_LOGGER.fatal(e.getMessage());
                    throw new IllegalStateException(e.getMessage(), e);
                }
                catch (CommStackMismatchException e) {
                    DSO_LOGGER.fatal(e.getMessage());
                    CONSOLE_LOGGER.fatal(e.getMessage());
                    throw new IllegalStateException(e.getMessage(), e);
                }
                catch (IOException ioe) {
                    CONSOLE_LOGGER.warn("IOException connecting to server: " + serverHost + ":" + serverPort + ". " + ioe.getMessage());
                    this.clientStopped.wait(5000L);
                }
            }
        }
    }

    private void waitForHandshake() {
        this.clientHandshakeManager.waitForHandshake();
        if (this.channel != null) {
            TCSocketAddress remoteAddress = this.channel.getRemoteAddress();
            String infoMsg = "Connection successfully established to server at " + remoteAddress;
            CONSOLE_LOGGER.info(infoMsg);
            DSO_LOGGER.info(infoMsg);
        }
    }

    private Map<TCMessageType, Class<? extends TCMessage>> getMessageTypeClassMapping() {
        HashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCMessage>>();
        messageTypeClassMapping.put(TCMessageType.LOCK_REQUEST_MESSAGE, LockRequestMessage.class);
        messageTypeClassMapping.put(TCMessageType.LOCK_RESPONSE_MESSAGE, LockResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.LOCK_RECALL_MESSAGE, LockResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.LOCK_QUERY_RESPONSE_MESSAGE, LockResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, ClientHandshakeMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, ClientHandshakeAckMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, ClientHandshakeRefusedMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, ClusterMembershipMessage.class);
        messageTypeClassMapping.put(TCMessageType.LIST_REGISTERED_SERVICES_MESSAGE, ListRegisteredServicesMessage.class);
        messageTypeClassMapping.put(TCMessageType.LIST_REGISTERED_SERVICES_RESPONSE_MESSAGE, ListRegisteredServicesResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.INVOKE_REGISTERED_SERVICE_MESSAGE, InvokeRegisteredServiceMessage.class);
        messageTypeClassMapping.put(TCMessageType.INVOKE_REGISTERED_SERVICE_RESPONSE_MESSAGE, InvokeRegisteredServiceResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MESSAGE, NetworkVoltronEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, VoltronEntityReceivedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_APPLIED_RESPONSE, VoltronEntityAppliedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, VoltronEntityRetiredResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.SERVER_ENTITY_MESSAGE, ServerEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.SERVER_ENTITY_RESPONSE_MESSAGE, ServerEntityResponseMessageImpl.class);
        return messageTypeClassMapping;
    }

    private void initChannelMessageRouter(TCMessageRouter messageRouter, Sink<HydrateContext> hydrateSink, Sink<Void> lockResponseSink, Sink<PauseContext> pauseSink, Sink<Void> clusterMembershipEventSink, Sink<VoltronEntityResponse> responseSink, Sink<Void> serverEntityMessageSink) {
        messageRouter.routeMessageType(TCMessageType.LOCK_RESPONSE_MESSAGE, lockResponseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.LOCK_QUERY_RESPONSE_MESSAGE, lockResponseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.LOCK_RECALL_MESSAGE, lockResponseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, pauseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, pauseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, clusterMembershipEventSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_APPLIED_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.SERVER_ENTITY_MESSAGE, serverEntityMessageSink, hydrateSink);
        DSO_LOGGER.debug("Added message routing types.");
    }

    public ClientLockManager getLockManager() {
        return this.lockManager;
    }

    public ClientEntityManager getEntityManager() {
        return this.clientEntityManager;
    }

    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    public ClientMessageChannel getChannel() {
        return this.channel;
    }

    public ClientHandshakeManager getClientHandshakeManager() {
        return this.clientHandshakeManager;
    }

    @Override
    public void dump() {
        this.dumpHandler.dump();
    }

    protected ClientConfig getClientConfigHelper() {
        return this.config;
    }

    public void shutdown() {
        this.shutdown(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownResources() {
        TCLogger logger = DSO_LOGGER;
        if (this.counterManager != null) {
            try {
                this.counterManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("error shutting down counter manager", t);
            }
            finally {
                this.counterManager = null;
            }
        }
        if (this.tcMemManager != null) {
            try {
                this.tcMemManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error stopping memory manager", t);
            }
            finally {
                this.tcMemManager = null;
            }
        }
        if (this.lockManager != null) {
            try {
                this.lockManager.shutdown(false);
            }
            catch (Throwable t) {
                logger.error("Error stopping lock manager", t);
            }
            finally {
                this.lockManager = null;
            }
        }
        try {
            this.communicationStageManager.stopAll();
        }
        catch (Throwable t) {
            logger.error("Error stopping stage manager", t);
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable t) {
                logger.error("Error closing channel", t);
            }
            finally {
                this.channel = null;
            }
        }
        if (this.communicationsManager != null) {
            try {
                this.communicationsManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error shutting down communications manager", t);
            }
            finally {
                this.communicationsManager = null;
            }
        }
        if (this.taskRunner != null) {
            logger.info("Shutting down TaskRunner");
            this.taskRunner.shutdown();
        }
        CommonShutDownHook.shutdown();
        this.cluster.shutdown();
        if (this.threadGroup != null) {
            boolean interrupted = false;
            try {
                long end = System.currentTimeMillis() + TCPropertiesImpl.getProperties().getLong("l1.shutdown.threadgroup.gracetime");
                int threadCount = this.threadGroup.activeCount();
                Thread[] t = new Thread[threadCount];
                threadCount = this.threadGroup.enumerate(t);
                long time = System.currentTimeMillis();
                for (int x = 0; x < threadCount; ++x) {
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() < end && t[x].isAlive()) {
                        t[x].join(1000L);
                    }
                    logger.info("Destroyed thread " + t[x].getName() + " time to destroy:" + (System.currentTimeMillis() - start) + " millis");
                }
                logger.info("time to destroy thread group:" + TimeUnit.SECONDS.convert(System.currentTimeMillis() - time, TimeUnit.MILLISECONDS) + " seconds");
                if (this.threadGroup.activeCount() > 0) {
                    logger.warn("Timed out waiting for TC thread group threads to die - probable shutdown memory leak\nLive threads: " + DistributedObjectClient.getLiveThreads(this.threadGroup));
                    Thread threadGroupCleanerThread = new Thread(this.threadGroup.getParent(), new TCThreadGroupCleanerRunnable(this.threadGroup), "TCThreadGroup last chance cleaner thread");
                    threadGroupCleanerThread.setDaemon(true);
                    threadGroupCleanerThread.start();
                    logger.warn("Spawning TCThreadGroup last chance cleaner thread");
                } else {
                    logger.info("Destroying TC thread group");
                    this.threadGroup.destroy();
                }
            }
            catch (Throwable t) {
                logger.error("Error destroying TC thread group", t);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (TCPropertiesImpl.getProperties().getBoolean("l1.shutdown.force.finalization")) {
            System.runFinalization();
        }
    }

    private static List<Thread> getLiveThreads(ThreadGroup group) {
        int estimate = group.activeCount();
        Thread[] threads = new Thread[estimate + 1];
        while (true) {
            int count;
            if ((count = group.enumerate(threads)) < threads.length) {
                ArrayList<Thread> l = new ArrayList<Thread>(count);
                for (Thread t : threads) {
                    if (t == null) continue;
                    l.add(t);
                }
                return l;
            }
            threads = new Thread[threads.length * 2];
        }
    }

    @Override
    public String[] processArguments() {
        return null;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownClient(boolean fromShutdownHook, boolean forceImmediate) {
        if (this.shutdownManager != null) {
            try {
                this.shutdownManager.execute(fromShutdownHook, forceImmediate);
            }
            finally {
                if (Thread.currentThread() != this.shutdownAction) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownAction);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean fromShutdownHook, boolean forceImmediate) {
        if (this.clientStopped.attemptSet()) {
            SetOnceFlag setOnceFlag = this.clientStopped;
            synchronized (setOnceFlag) {
                this.clientStopped.notifyAll();
            }
            DSO_LOGGER.info("shuting down Terracotta Client hook=" + fromShutdownHook + " force=" + forceImmediate);
            this.shutdownClient(fromShutdownHook, forceImmediate);
        } else {
            DSO_LOGGER.info("Client already shutdown.");
        }
    }

    private class ShutdownAction
    implements Runnable {
        private ShutdownAction() {
        }

        @Override
        public void run() {
            DSO_LOGGER.info("Running L1 VM shutdown hook");
            DistributedObjectClient.this.shutdown(true, false);
        }
    }

    private static class TCThreadGroupCleanerRunnable
    implements Runnable {
        private final TCThreadGroup threadGroup;

        public TCThreadGroupCleanerRunnable(TCThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        @Override
        public void run() {
            while (this.threadGroup.activeCount() > 0) {
                for (Thread liveThread : DistributedObjectClient.getLiveThreads(this.threadGroup)) {
                    liveThread.interrupt();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            try {
                this.threadGroup.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

