/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageCodec;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.ResponseCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EhcacheCodec
implements MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> SERVER_INSTANCE = new EhcacheCodec(new ServerStoreOpCodec(), new LifeCycleMessageCodec(), new ResponseCodec());
    private final ServerStoreOpCodec serverStoreOpCodec;
    private final LifeCycleMessageCodec lifeCycleMessageCodec;
    private final ResponseCodec responseCodec;

    public static MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> messageCodec() {
        return SERVER_INSTANCE;
    }

    private EhcacheCodec(ServerStoreOpCodec serverStoreOpCodec, LifeCycleMessageCodec lifeCycleMessageCodec, ResponseCodec responseCodec) {
        this.serverStoreOpCodec = serverStoreOpCodec;
        this.lifeCycleMessageCodec = lifeCycleMessageCodec;
        this.responseCodec = responseCodec;
    }

    @Override
    public byte[] encodeMessage(EhcacheEntityMessage message) {
        if (message.getType() == EhcacheEntityMessage.Type.LIFECYCLE_OP) {
            return this.lifeCycleMessageCodec.encode((LifecycleMessage)message);
        }
        return this.serverStoreOpCodec.encode((ServerStoreOpMessage)message);
    }

    @Override
    public EhcacheEntityMessage decodeMessage(byte[] payload) throws MessageCodecException {
        byte opcode = payload[0];
        if (opcode == 1) {
            return this.lifeCycleMessageCodec.decode(payload);
        }
        return this.serverStoreOpCodec.decode(payload);
    }

    @Override
    public byte[] encodeResponse(EhcacheEntityResponse response) throws MessageCodecException {
        return this.responseCodec.encode(response);
    }

    @Override
    public EhcacheEntityResponse decodeResponse(byte[] payload) throws MessageCodecException {
        return this.responseCodec.decode(payload);
    }
}

