/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config.builders;

import java.net.URI;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.builders.ServerSideConfigurationBuilder;
import org.ehcache.config.Builder;

public final class ClusteringServiceConfigurationBuilder
implements Builder<ClusteringServiceConfiguration> {
    private final URI clusterUri;

    public static ClusteringServiceConfigurationBuilder cluster(URI clusterUri) {
        return new ClusteringServiceConfigurationBuilder(clusterUri);
    }

    private ClusteringServiceConfigurationBuilder(URI clusterUri) {
        this.clusterUri = clusterUri;
    }

    public ServerSideConfigurationBuilder autoCreate() {
        return new ServerSideConfigurationBuilder(this.clusterUri, true);
    }

    public ServerSideConfigurationBuilder expecting() {
        return new ServerSideConfigurationBuilder(this.clusterUri, false);
    }

    public ClusteringServiceConfiguration build() {
        return new ClusteringServiceConfiguration(this.clusterUri);
    }
}

