/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.net.core.SecurityInfo;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.DistributedObjectClientFactory;
import com.tc.object.locks.ClientLockManager;
import com.tc.util.ProductID;
import com.terracotta.connection.ClientHandle;
import com.terracotta.connection.ClientHandleImpl;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.client.TerracottaClientStripeConnectionConfig;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

public class TerracottaInternalClientImpl
implements TerracottaInternalClient {
    private final DistributedObjectClientFactory clientCreator;
    private volatile ClientHandle clientHandle;
    private volatile boolean shutdown = false;
    private volatile boolean isInitialized = false;

    TerracottaInternalClientImpl(TerracottaClientStripeConnectionConfig stripeConnectionConfig, String productId, Properties props) {
        try {
            this.clientCreator = this.buildClientCreator(stripeConnectionConfig, productId, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DistributedObjectClientFactory buildClientCreator(TerracottaClientStripeConnectionConfig stripeConnectionConfig, String productIdName, Properties props) {
        ProductID productId = productIdName == null ? ProductID.USER : ProductID.valueOf(productIdName);
        return new DistributedObjectClientFactory(stripeConnectionConfig.getStripeMemberUris(), null, new SecurityInfo(false, null), productId, props);
    }

    @Override
    public synchronized void init() throws TimeoutException, InterruptedException, ConfigurationSetupException {
        if (this.isInitialized) {
            return;
        }
        DistributedObjectClient client = this.clientCreator.create();
        if (client == null) {
            throw new TimeoutException();
        }
        this.clientHandle = new ClientHandleImpl(client);
        this.isInitialized = true;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            if (this.clientHandle != null) {
                this.clientHandle.shutdown();
            }
        }
        finally {
            this.clientHandle = null;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public ClientEntityManager getClientEntityManager() {
        return this.clientHandle.getClientEntityManager();
    }

    @Override
    public ClientLockManager getClientLockManager() {
        return this.clientHandle.getClientLockManager();
    }

    static class ClientShutdownException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ClientShutdownException() {
        }
    }
}

