/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.MessageID;
import java.io.IOException;

public class PlatformInfoRequest
extends AbstractGroupMessage {
    public static final int REQUEST = 0;
    public static final int SERVER_INFO = 1;
    public static final int SERVER_STATE = 2;
    private RequestType requestType;
    private String name;
    private String version;
    private String build;
    private String state;
    private long startTime;
    private long activateTime;

    public PlatformInfoRequest() {
        this(0);
    }

    public PlatformInfoRequest(int type) {
        super(type);
    }

    public PlatformInfoRequest(String state, long activate, MessageID requestID) {
        this(2, requestID);
        this.state = state;
        this.activateTime = activate;
    }

    public PlatformInfoRequest(String name, String version, String buildid, long startTime, MessageID requestID) {
        this(1, requestID);
        this.name = name;
        this.build = buildid;
        this.version = version;
        this.startTime = startTime;
    }

    private PlatformInfoRequest(int type, MessageID requestID) {
        super(type, requestID);
    }

    public void setRequestType(RequestType type) {
        this.requestType = type;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getActivateTime() {
        return this.activateTime;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        if (this.getType() == 0) {
            this.requestType = RequestType.values()[in.readInt()];
        } else if (this.getType() == 1) {
            this.name = in.readString();
            this.version = in.readString();
            this.build = in.readString();
            this.startTime = in.readLong();
        } else if (this.getType() == 2) {
            this.state = in.readString();
            this.activateTime = in.readLong();
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        if (this.getType() == 0) {
            if (this.requestType != null) {
                out.writeInt(this.requestType.ordinal());
            } else {
                out.writeInt(-1);
            }
        } else if (this.getType() == 1) {
            out.writeString(this.name);
            out.writeString(this.version);
            out.writeString(this.build);
            out.writeLong(this.startTime);
        } else if (this.getType() == 2) {
            out.writeString(this.state);
            out.writeLong(this.activateTime);
        }
    }

    public static enum RequestType {
        SERVER_INFO;

    }
}

