/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.maven;

import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.maven.plugin.logging.Log;

public class MavenLog4JConfigurator {
    protected static final Level LOG4J_DEFAULT_LOG_LEVEL = Level.INFO;

    public void configureLog4j(Log log) {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            try {
                Logger.getRootLogger().setLevel(LOG4J_DEFAULT_LOG_LEVEL);
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            Logger.getRootLogger().addAppender((Appender)this.createMojoLogAppender(log));
        } else {
            this.configureLog4j(log, "org.eclipse.xtext");
            this.configureLog4j(log, "org.eclipse.xtend");
        }
    }

    protected void configureLog4j(Log log, String name) {
        Logger logger = Logger.getLogger((String)name);
        logger.setAdditivity(false);
        try {
            logger.setLevel(LOG4J_DEFAULT_LOG_LEVEL);
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        logger.removeAllAppenders();
        logger.addAppender((Appender)this.createMojoLogAppender(log));
    }

    protected AppenderSkeleton createMojoLogAppender(final Log log) {
        return new AppenderSkeleton(){

            protected void append(LoggingEvent event) {
                if (event.getMessage() == null) {
                    return;
                }
                Throwable throwable = this.getThrowable(event);
                String message = String.valueOf(event.getMessage());
                if (throwable != null) {
                    if (Level.DEBUG == event.getLevel()) {
                        log.debug((CharSequence)message, throwable);
                    } else if (Level.INFO == event.getLevel()) {
                        log.info((CharSequence)message, throwable);
                    } else if (Level.WARN == event.getLevel()) {
                        log.warn((CharSequence)message, throwable);
                    } else if (Level.ERROR == event.getLevel()) {
                        log.error((CharSequence)message, throwable);
                    }
                } else if (Level.DEBUG == event.getLevel()) {
                    log.debug((CharSequence)message);
                } else if (Level.INFO == event.getLevel()) {
                    log.info((CharSequence)message);
                } else if (Level.WARN == event.getLevel()) {
                    log.warn((CharSequence)message);
                } else if (Level.ERROR == event.getLevel()) {
                    log.error((CharSequence)message);
                }
            }

            public void close() {
            }

            private Throwable getThrowable(LoggingEvent event) {
                if (event.getThrowableInformation() != null) {
                    return event.getThrowableInformation().getThrowable();
                }
                return null;
            }

            public boolean requiresLayout() {
                return false;
            }
        };
    }
}

