/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.web.server.generator.GeneratorResult;
import org.eclipse.xtext.web.servlet.HttpServiceContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;

public class XtextServlet
extends HttpServlet {
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private final IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    private final Gson gson = new Gson();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException.ResourceNotFoundException) {
                InvalidRequestException.ResourceNotFoundException exception = (InvalidRequestException.ResourceNotFoundException)_t;
                String _requestURI = req.getRequestURI();
                String _plus = "Invalid request (" + _requestURI;
                String _plus_1 = _plus + "): ";
                String _message = exception.getMessage();
                String _plus_2 = _plus_1 + _message;
                this.LOG.trace((Object)_plus_2);
                String _message_1 = exception.getMessage();
                resp.sendError(404, _message_1);
            }
            if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                InvalidRequestException.InvalidDocumentStateException exception_1 = (InvalidRequestException.InvalidDocumentStateException)_t;
                String _requestURI_1 = req.getRequestURI();
                String _plus_3 = "Invalid request (" + _requestURI_1;
                String _plus_4 = _plus_3 + "): ";
                String _message_2 = exception_1.getMessage();
                String _plus_5 = _plus_4 + _message_2;
                this.LOG.trace((Object)_plus_5);
                String _message_3 = exception_1.getMessage();
                resp.sendError(409, _message_3);
            }
            if (_t instanceof InvalidRequestException.PermissionDeniedException) {
                InvalidRequestException.PermissionDeniedException exception_2 = (InvalidRequestException.PermissionDeniedException)_t;
                String _requestURI_2 = req.getRequestURI();
                String _plus_6 = "Invalid request (" + _requestURI_2;
                String _plus_7 = _plus_6 + "): ";
                String _message_4 = exception_2.getMessage();
                String _plus_8 = _plus_7 + _message_4;
                this.LOG.trace((Object)_plus_8);
                String _message_5 = exception_2.getMessage();
                resp.sendError(403, _message_5);
            }
            if (_t instanceof InvalidRequestException) {
                InvalidRequestException exception_3 = (InvalidRequestException)_t;
                String _requestURI_3 = req.getRequestURI();
                String _plus_9 = "Invalid request (" + _requestURI_3;
                String _plus_10 = _plus_9 + "): ";
                String _message_6 = exception_3.getMessage();
                String _plus_11 = _plus_10 + _message_6;
                this.LOG.trace((Object)_plus_11);
                String _message_7 = exception_3.getMessage();
                resp.sendError(400, _message_7);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        if (!_not) {
            _and = false;
        } else {
            boolean _hasTextInput;
            boolean _or = false;
            boolean _isHasSideEffects = service.isHasSideEffects();
            _or = _isHasSideEffects ? true : (_hasTextInput = this.hasTextInput(service));
            _and = _or;
        }
        if (_and) {
            super.doGet(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _notEquals;
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        IServiceContext _context = service.getContext();
        String type = _context.getParameter("serviceType");
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        _and = !_not ? false : (_notEquals = !Objects.equal((Object)type, (Object)"update"));
        if (_and) {
            super.doPut(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean _not;
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        IServiceContext _context = service.getContext();
        String type = _context.getParameter("serviceType");
        boolean _and = false;
        boolean _isHasConflict = service.isHasConflict();
        boolean bl = _not = !_isHasConflict;
        if (!_not) {
            _and = false;
        } else {
            boolean _equals;
            boolean _hasTextInput;
            boolean _not_2;
            boolean _not_1;
            boolean _or = false;
            boolean _and_1 = false;
            boolean _isHasSideEffects = service.isHasSideEffects();
            boolean bl2 = _not_1 = !_isHasSideEffects;
            _and_1 = !_not_1 ? false : (_not_2 = !(_hasTextInput = this.hasTextInput(service)));
            _or = _and_1 ? true : (_equals = Objects.equal((Object)type, (Object)"update"));
            _and = _or;
        }
        if (_and) {
            super.doPost(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected boolean hasTextInput(XtextServiceDispatcher.ServiceDescriptor service) {
        boolean _contains_1;
        boolean _xblockexpression = false;
        IServiceContext _context = service.getContext();
        Set parameterKeys = _context.getParameterKeys();
        boolean _or = false;
        boolean _contains = parameterKeys.contains("fullText");
        _or = _contains ? true : (_contains_1 = parameterKeys.contains("deltaText"));
        _xblockexpression = _or;
        return _xblockexpression;
    }

    protected XtextServiceDispatcher.ServiceDescriptor getService(HttpServletRequest request) throws InvalidRequestException {
        HttpServiceContext serviceContext = new HttpServiceContext(request);
        Injector injector = this.getInjector(serviceContext);
        XtextServiceDispatcher serviceDispatcher = (XtextServiceDispatcher)injector.getInstance(XtextServiceDispatcher.class);
        XtextServiceDispatcher.ServiceDescriptor service = serviceDispatcher.getService((IServiceContext)serviceContext);
        return service;
    }

    protected void doService(XtextServiceDispatcher.ServiceDescriptor service, HttpServletResponse response) {
        try {
            Functions.Function0 _service = service.getService();
            IServiceResult result = (IServiceResult)_service.apply();
            response.setStatus(200);
            String _encoding = this.getEncoding(service, result);
            response.setCharacterEncoding(_encoding);
            response.setHeader("Cache-Control", "no-cache");
            if (result instanceof GeneratorResult) {
                String _elvis = null;
                String _contentType = ((GeneratorResult)result).getContentType();
                _elvis = _contentType != null ? _contentType : "text/plain";
                response.setContentType(_elvis);
                PrintWriter _writer = response.getWriter();
                String _content = ((GeneratorResult)result).getContent();
                _writer.write(_content);
            } else {
                response.setContentType("text/x-json");
                PrintWriter _writer_1 = response.getWriter();
                this.gson.toJson((Object)result, (Appendable)_writer_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getEncoding(XtextServiceDispatcher.ServiceDescriptor service, IServiceResult result) {
        return "UTF-8";
    }

    protected Injector getInjector(HttpServiceContext serviceContext) throws InvalidRequestException.UnknownLanguageException {
        IResourceServiceProvider resourceServiceProvider = null;
        String _elvis = null;
        String _parameter = serviceContext.getParameter("resource");
        _elvis = _parameter != null ? _parameter : "";
        URI emfURI = URI.createURI((String)_elvis);
        String contentType = serviceContext.getParameter("contentType");
        if (contentType == null) {
            IResourceServiceProvider _resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(emfURI);
            resourceServiceProvider = _resourceServiceProvider;
            boolean _equals = Objects.equal((Object)resourceServiceProvider, null);
            if (_equals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Unable to identify the Xtext language for resource ");
                _builder.append((Object)emfURI, "");
                _builder.append((Object)".");
                throw new InvalidRequestException.UnknownLanguageException(_builder.toString());
            }
        } else {
            IResourceServiceProvider _resourceServiceProvider_1 = this.serviceProviderRegistry.getResourceServiceProvider(emfURI, contentType);
            resourceServiceProvider = _resourceServiceProvider_1;
            boolean _equals_1 = Objects.equal((Object)resourceServiceProvider, null);
            if (_equals_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Unable to identify the Xtext language for contentType ");
                _builder_1.append((Object)contentType, "");
                _builder_1.append((Object)".");
                throw new InvalidRequestException.UnknownLanguageException(_builder_1.toString());
            }
        }
        return (Injector)resourceServiceProvider.get(Injector.class);
    }
}

