/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.web.server.IRequestData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class HttpServletRequestData
implements IRequestData {
    private final HttpServletRequest request;
    private final Map<String, String> parameters = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    @Accessors
    private final Set<String> metadataKeys = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"authType", "characterEncoding", "contentType", "contextPath", "localAddr", "localName", "localPort", "method", "pathInfo", "pathTranslated", "protocol", "queryString", "remoteAddr", "remoteHost", "remotePort", "remoteUser", "requestedSessionId", "requestURI", "scheme", "serverName", "serverPort", "servletPath"}));

    public HttpServletRequestData(HttpServletRequest request) {
        this.request = request;
        this.initializeParameters();
    }

    private String initializeParameters() {
        try {
            boolean _not;
            String _xblockexpression = null;
            String _contentType = this.request.getContentType();
            String[] _split = null;
            if (_contentType != null) {
                _split = _contentType.split(";(\\s*)");
            }
            String[] contentType = _split;
            boolean _and = false;
            if (contentType == null) {
                _and = false;
            } else {
                boolean _equals;
                String _get = contentType[0];
                _and = _equals = Objects.equal((Object)_get, (Object)"application/x-www-form-urlencoded");
            }
            if (_and) {
                String[] encodedParams;
                int _length;
                boolean _greaterEqualsThan;
                String _xifexpression = null;
                boolean _and_1 = false;
                boolean _and_2 = false;
                _and_2 = contentType == null ? false : (_greaterEqualsThan = (_length = contentType.length) >= 2);
                if (!_and_2) {
                    _and_1 = false;
                } else {
                    boolean _startsWith;
                    String _get_1 = contentType[1];
                    _and_1 = _startsWith = _get_1.startsWith("charset=");
                }
                if (_and_1) {
                    String _get_2 = contentType[1];
                    int _length_1 = "charset=".length();
                    _xifexpression = _get_2.substring(_length_1);
                } else {
                    Charset _defaultCharset = Charset.defaultCharset();
                    _xifexpression = _defaultCharset.toString();
                }
                String charset = _xifexpression;
                BufferedReader _reader = this.request.getReader();
                String _string = CharStreams.toString((Readable)_reader);
                for (String param : encodedParams = _string.split("&")) {
                    int nameEnd = param.indexOf("=");
                    if (nameEnd <= 0) continue;
                    String key = param.substring(0, nameEnd);
                    String _substring = param.substring(nameEnd + 1);
                    String value = URLDecoder.decode(_substring, charset);
                    this.parameters.put(key, value);
                }
            }
            Enumeration paramNames = this.request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                String _parameter = this.request.getParameter(name);
                this.parameters.put(name, _parameter);
            }
            String _xifexpression_1 = null;
            boolean _containsKey = this.parameters.containsKey("serviceType");
            boolean bl = _not = !_containsKey;
            if (_not) {
                String _pathInfo = this.request.getPathInfo();
                String _substring = null;
                if (_pathInfo != null) {
                    _substring = _pathInfo.substring(1);
                }
                _xifexpression_1 = this.parameters.put("serviceType", _substring);
            }
            _xblockexpression = _xifexpression_1;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<String> getParameterKeys() {
        Set<String> _keySet = this.parameters.keySet();
        return Collections.unmodifiableSet(_keySet);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getMetadata(String key) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)key, (Object)"authType")) {
            _matched = true;
            _switchResult = this.request.getAuthType();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"characterEncoding")) {
            _matched = true;
            _switchResult = this.request.getCharacterEncoding();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"contentType")) {
            _matched = true;
            _switchResult = this.request.getContentType();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"contextPath")) {
            _matched = true;
            _switchResult = this.request.getContextPath();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"localAddr")) {
            _matched = true;
            _switchResult = this.request.getLocalAddr();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"localName")) {
            _matched = true;
            _switchResult = this.request.getLocalName();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"localPort")) {
            _matched = true;
            int _localPort = this.request.getLocalPort();
            _switchResult = Integer.valueOf(_localPort).toString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"method")) {
            _matched = true;
            _switchResult = this.request.getMethod();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"pathInfo")) {
            _matched = true;
            _switchResult = this.request.getPathInfo();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"pathTranslated")) {
            _matched = true;
            _switchResult = this.request.getPathTranslated();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"protocol")) {
            _matched = true;
            _switchResult = this.request.getProtocol();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"queryString")) {
            _matched = true;
            _switchResult = this.request.getQueryString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remoteAddr")) {
            _matched = true;
            _switchResult = this.request.getRemoteAddr();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remoteHost")) {
            _matched = true;
            _switchResult = this.request.getRemoteHost();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remotePort")) {
            _matched = true;
            int _remotePort = this.request.getRemotePort();
            _switchResult = Integer.valueOf(_remotePort).toString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remoteUser")) {
            _matched = true;
            _switchResult = this.request.getRemoteUser();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"requestedSessionId")) {
            _matched = true;
            _switchResult = this.request.getRequestedSessionId();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"requestURI")) {
            _matched = true;
            _switchResult = this.request.getRequestURI();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"scheme")) {
            _matched = true;
            _switchResult = this.request.getScheme();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"serverName")) {
            _matched = true;
            _switchResult = this.request.getServerName();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"serverPort")) {
            _matched = true;
            int _serverPort = this.request.getServerPort();
            _switchResult = Integer.valueOf(_serverPort).toString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"servletPath")) {
            _matched = true;
            _switchResult = this.request.getServletPath();
        }
        return _switchResult;
    }

    @Pure
    public Set<String> getMetadataKeys() {
        return this.metadataKeys;
    }
}

