/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.web.server.IRequestData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;

public class HttpServletRequestData
implements IRequestData {
    private final HttpServletRequest request;
    @Accessors
    private final Set<String> parameterKeys;
    @Accessors
    private final Set<String> metadataKeys;

    public HttpServletRequestData(HttpServletRequest request) {
        this.request = request;
        Enumeration paramNames = request.getParameterNames();
        HashSet set = CollectionLiterals.newHashSet((Object[])new String[0]);
        while (paramNames.hasMoreElements()) {
            String _nextElement = (String)paramNames.nextElement();
            set.add(_nextElement);
        }
        set.add("requestType");
        Set _unmodifiableSet = Collections.unmodifiableSet(set);
        this.parameterKeys = _unmodifiableSet;
        this.metadataKeys = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"authType", "characterEncoding", "contentType", "contextPath", "localAddr", "localName", "localPort", "method", "pathInfo", "pathTranslated", "protocol", "queryString", "remoteAddr", "remoteHost", "remotePort", "remoteUser", "requestedSessionId", "requestURI", "scheme", "serverName", "serverPort", "servletPath"}));
    }

    public String getParameter(String key) {
        boolean _equals;
        String value = this.request.getParameter(key);
        boolean _and = false;
        _and = value != null ? false : (_equals = Objects.equal((Object)key, (Object)"requestType"));
        if (_and) {
            String _pathInfo = this.request.getPathInfo();
            String _substring = null;
            if (_pathInfo != null) {
                _substring = _pathInfo.substring(1);
            }
            return _substring;
        }
        return value;
    }

    public String getMetadata(String key) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)key, (Object)"authType")) {
            _matched = true;
            _switchResult = this.request.getAuthType();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"characterEncoding")) {
            _matched = true;
            _switchResult = this.request.getCharacterEncoding();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"contentType")) {
            _matched = true;
            _switchResult = this.request.getContentType();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"contextPath")) {
            _matched = true;
            _switchResult = this.request.getContextPath();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"localAddr")) {
            _matched = true;
            _switchResult = this.request.getLocalAddr();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"localName")) {
            _matched = true;
            _switchResult = this.request.getLocalName();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"localPort")) {
            _matched = true;
            int _localPort = this.request.getLocalPort();
            _switchResult = Integer.valueOf(_localPort).toString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"method")) {
            _matched = true;
            _switchResult = this.request.getMethod();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"pathInfo")) {
            _matched = true;
            _switchResult = this.request.getPathInfo();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"pathTranslated")) {
            _matched = true;
            _switchResult = this.request.getPathTranslated();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"protocol")) {
            _matched = true;
            _switchResult = this.request.getProtocol();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"queryString")) {
            _matched = true;
            _switchResult = this.request.getQueryString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remoteAddr")) {
            _matched = true;
            _switchResult = this.request.getRemoteAddr();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remoteHost")) {
            _matched = true;
            _switchResult = this.request.getRemoteHost();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remotePort")) {
            _matched = true;
            int _remotePort = this.request.getRemotePort();
            _switchResult = Integer.valueOf(_remotePort).toString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"remoteUser")) {
            _matched = true;
            _switchResult = this.request.getRemoteUser();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"requestedSessionId")) {
            _matched = true;
            _switchResult = this.request.getRequestedSessionId();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"requestURI")) {
            _matched = true;
            _switchResult = this.request.getRequestURI();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"scheme")) {
            _matched = true;
            _switchResult = this.request.getScheme();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"serverName")) {
            _matched = true;
            _switchResult = this.request.getServerName();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"serverPort")) {
            _matched = true;
            int _serverPort = this.request.getServerPort();
            _switchResult = Integer.valueOf(_serverPort).toString();
        }
        if (!_matched && Objects.equal((Object)key, (Object)"servletPath")) {
            _matched = true;
            _switchResult = this.request.getServletPath();
        }
        return _switchResult;
    }

    @Pure
    public Set<String> getParameterKeys() {
        return this.parameterKeys;
    }

    @Pure
    public Set<String> getMetadataKeys() {
        return this.metadataKeys;
    }
}

