/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import javax.servlet.http.HttpSession;
import org.eclipse.xtext.web.server.ISession;
import org.eclipse.xtext.xbase.lib.Functions;

public class HttpSessionWrapper
implements ISession {
    private final HttpSession session;

    public <T> T get(Object key) {
        return (T)this.session.getAttribute(key.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Functions.Function0<? extends T> factory) {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            T sessionValue = this.get(key);
            if (sessionValue != null) {
                return sessionValue;
            }
            Object factoryValue = factory.apply();
            this.put(key, factoryValue);
            return (T)factoryValue;
        }
    }

    public void put(Object key, Object value) {
        this.session.setAttribute(key.toString(), value);
    }

    public void remove(Object key) {
        this.session.removeAttribute(key.toString());
    }

    public HttpSessionWrapper(HttpSession session) {
        this.session = session;
    }

    public HttpSession getSession() {
        return this.session;
    }
}

