/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.incremental.BuildContext;
import org.eclipse.xtext.builder.standalone.incremental.BuildRequest;
import org.eclipse.xtext.builder.standalone.incremental.FilesAndURIs;
import org.eclipse.xtext.builder.standalone.incremental.IClassFileBasedDependencyFinder;
import org.eclipse.xtext.builder.standalone.incremental.IndexState;
import org.eclipse.xtext.builder.standalone.incremental.JavaSupport;
import org.eclipse.xtext.builder.standalone.incremental.ResolvedResourceDescription;
import org.eclipse.xtext.builder.standalone.incremental.ResourceURICollector;
import org.eclipse.xtext.builder.standalone.incremental.Source2GeneratedMapping;
import org.eclipse.xtext.builder.standalone.incremental.TypeResourceDescription;
import org.eclipse.xtext.mwe.ResourceDescriptionsProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class Indexer {
    private static final Logger LOG = Logger.getLogger(Indexer.class);
    @Inject
    private ResourceURICollector uriCollector;
    @Inject
    private JavaSupport javaSupport;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IClassFileBasedDependencyFinder javaDependencyFinder;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public IndexResult computeAndIndexAffected(final BuildRequest request, final @Extension BuildContext context) {
        boolean fullBuild = request.isFullBuild();
        if (fullBuild) {
            LOG.info((Object)"Performing full build");
        } else {
            LOG.info((Object)"Performing incremental build");
        }
        LOG.info((Object)"Creating new index");
        IndexState _previousState = request.getPreviousState();
        final Source2GeneratedMapping fileMappings = _previousState.getFileMappings();
        IndexState _previousState_1 = request.getPreviousState();
        final ResourceDescriptionsData oldIndex = _previousState_1.getResourceDescriptions();
        final ResourceDescriptionsData newIndex = oldIndex.copy();
        XtextResourceSet _resourceSet = context.getResourceSet();
        final IResourceDescriptions resourceDescriptions = this.installIndex(_resourceSet, newIndex);
        Map<String, LanguageAccess> _languages = context.getLanguages();
        Set<Map.Entry<String, LanguageAccess>> _entrySet = _languages.entrySet();
        Functions.Function1<Map.Entry<String, LanguageAccess>, Boolean> _function = new Functions.Function1<Map.Entry<String, LanguageAccess>, Boolean>(){

            public Boolean apply(Map.Entry<String, LanguageAccess> it) {
                LanguageAccess _value = it.getValue();
                return _value.isLinksAgainstJava();
            }
        };
        boolean isConsiderJava = IterableExtensions.exists(_entrySet, (Functions.Function1)_function);
        final HashSet affectionCandidates = CollectionLiterals.newHashSet((Object[])new URI[0]);
        Set directlyAffected = null;
        if (fullBuild) {
            Set _set;
            Iterable<URI> _collectAllResources = this.uriCollector.collectAllResources(request, context);
            directlyAffected = _set = IterableExtensions.toSet(_collectAllResources);
        } else {
            Set _set_1;
            List<URI> _dirtyFiles = request.getDirtyFiles();
            List<URI> _deletedFiles = request.getDeletedFiles();
            Iterable _plus = Iterables.concat(_dirtyFiles, _deletedFiles);
            final Set allModified = IterableExtensions.toSet((Iterable)_plus);
            Set _allURIs = oldIndex.getAllURIs();
            Functions.Function1<URI, Boolean> _function_1 = new Functions.Function1<URI, Boolean>(){

                public Boolean apply(URI it) {
                    boolean _contains = allModified.contains(it);
                    return !_contains;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_allURIs, (Functions.Function1)_function_1);
            Iterables.addAll((Collection)affectionCandidates, (Iterable)_filter);
            List<URI> _dirtyFiles_1 = request.getDirtyFiles();
            Functions.Function1<URI, Iterable<URI>> _function_2 = new Functions.Function1<URI, Iterable<URI>>(){

                public Iterable<URI> apply(URI it) {
                    return Indexer.this.primarySources(it, fileMappings);
                }
            };
            List _map = ListExtensions.map(_dirtyFiles_1, (Functions.Function1)_function_2);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            directlyAffected = _set_1 = IterableExtensions.toSet((Iterable)_flatten);
        }
        final ArrayList currentDeltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
        ArrayList<IResourceDescription.Delta> _removeDeletedFilesFromIndex = this.removeDeletedFilesFromIndex(request, oldIndex, newIndex);
        Iterables.addAll((Collection)currentDeltas, _removeDeletedFilesFromIndex);
        if (isConsiderJava) {
            List<URI> _sourceRoots = request.getSourceRoots();
            List<URI> _outputs = request.getOutputs();
            Iterable _plus_1 = Iterables.concat(_sourceRoots, _outputs);
            List<URI> _classPath = request.getClassPath();
            Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, _classPath);
            XtextResourceSet _resourceSet_1 = context.getResourceSet();
            this.javaSupport.installLocalOnlyTypeProvider(_plus_2, _resourceSet_1);
        }
        this.preIndexChangedResources(directlyAffected, oldIndex, newIndex, request, context);
        if (isConsiderJava) {
            URI preCompiledClasses = this.javaSupport.preCompileJavaFiles(directlyAffected, newIndex, request, context);
            List<URI> _sourceRoots_1 = request.getSourceRoots();
            Iterable _plus_3 = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{preCompiledClasses})), _sourceRoots_1);
            List<URI> _outputs_1 = request.getOutputs();
            Iterable _plus_4 = Iterables.concat((Iterable)_plus_3, _outputs_1);
            List<URI> _classPath_1 = request.getClassPath();
            Iterable _plus_5 = Iterables.concat((Iterable)_plus_4, _classPath_1);
            XtextResourceSet _resourceSet_2 = context.getResourceSet();
            this.javaSupport.installTypeProvider(_plus_5, _resourceSet_2);
        }
        LOG.info((Object)"Indexing changed and added files");
        HashSet allAffected = CollectionLiterals.newHashSet((Object[])new URI[0]);
        Iterables.addAll((Collection)allAffected, (Iterable)directlyAffected);
        HashSet toBeIndexed = CollectionLiterals.newHashSet((Object[])new URI[0]);
        toBeIndexed.addAll(directlyAffected);
        final HashSet allDeltas = CollectionLiterals.newHashSet((Object[])new IResourceDescription.Delta[0]);
        while (!toBeIndexed.isEmpty()) {
            boolean _not;
            boolean _and = false;
            if (!isConsiderJava) {
                _and = false;
            } else {
                boolean bl = _and = !fullBuild;
            }
            if (_and) {
                Functions.Function1<URI, Iterable<URI>> _function_3 = new Functions.Function1<URI, Iterable<URI>>(){

                    public Iterable<URI> apply(URI it) {
                        return fileMappings.getGenerated(it);
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)toBeIndexed, (Functions.Function1)_function_3);
                Iterable _flatten_1 = Iterables.concat((Iterable)_map_1);
                Iterable _plus_6 = Iterables.concat((Iterable)_flatten_1, (Iterable)toBeIndexed);
                Functions.Function1<URI, Boolean> _function_4 = new Functions.Function1<URI, Boolean>(){

                    public Boolean apply(URI it) {
                        String _fileExtension = it.fileExtension();
                        return Objects.equal((Object)_fileExtension, (Object)"java");
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_plus_6, (Functions.Function1)_function_4);
                Set affectedJavaFiles = IterableExtensions.toSet((Iterable)_filter_1);
                List<URI> _deletedFiles_1 = request.getDeletedFiles();
                Functions.Function1<URI, Iterable<URI>> _function_5 = new Functions.Function1<URI, Iterable<URI>>(){

                    public Iterable<URI> apply(URI it) {
                        return Indexer.this.primarySources(it, fileMappings);
                    }
                };
                List _map_2 = ListExtensions.map(_deletedFiles_1, (Functions.Function1)_function_5);
                Iterable _flatten_2 = Iterables.concat((Iterable)_map_2);
                Functions.Function1<URI, Boolean> _function_6 = new Functions.Function1<URI, Boolean>(){

                    public Boolean apply(URI it) {
                        String _fileExtension = it.fileExtension();
                        return Objects.equal((Object)_fileExtension, (Object)"java");
                    }
                };
                Iterable deletedPrimaryJavaFiles = IterableExtensions.filter((Iterable)_flatten_2, (Functions.Function1)_function_6);
                Iterable<? extends URI> dependentJavaFiles = this.javaDependencyFinder.getDependentJavaFiles(affectedJavaFiles, deletedPrimaryJavaFiles);
                Functions.Function1<URI, Iterable<URI>> _function_7 = new Functions.Function1<URI, Iterable<URI>>(){

                    public Iterable<URI> apply(URI it) {
                        return Indexer.this.primarySources(it, fileMappings);
                    }
                };
                Iterable _map_3 = IterableExtensions.map(dependentJavaFiles, (Functions.Function1)_function_7);
                Iterable _flatten_3 = Iterables.concat((Iterable)_map_3);
                Functions.Function1<URI, Boolean> _function_8 = new Functions.Function1<URI, Boolean>(){

                    public Boolean apply(URI it) {
                        boolean _contains;
                        boolean _or = false;
                        String _fileExtension = it.fileExtension();
                        boolean _equals = Objects.equal((Object)_fileExtension, (Object)"java");
                        _or = _equals ? true : (_contains = affectionCandidates.contains(it));
                        return _or;
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter((Iterable)_flatten_3, (Functions.Function1)_function_8);
                Iterables.addAll((Collection)toBeIndexed, (Iterable)_filter_2);
            }
            allAffected.addAll(toBeIndexed);
            affectionCandidates.removeAll(toBeIndexed);
            Functions.Function1<Resource, Object> _function_9 = new Functions.Function1<Resource, Object>(){

                public Object apply(Resource resource) {
                    Object _xblockexpression = null;
                    URI _uRI = resource.getURI();
                    String _plus = "Indexing " + _uRI;
                    LOG.info((Object)_plus);
                    DefaultResourceDescriptionDelta _addToIndex = Indexer.this.addToIndex(resource, false, oldIndex, newIndex, context);
                    currentDeltas.add(_addToIndex);
                    _xblockexpression = null;
                    return _xblockexpression;
                }
            };
            context.executeClustered(toBeIndexed, _function_9);
            Functions.Function1<URI, Boolean> _function_10 = new Functions.Function1<URI, Boolean>(){

                public Boolean apply(URI it) {
                    String _fileExtension = it.fileExtension();
                    return Objects.equal((Object)_fileExtension, (Object)"java");
                }
            };
            Iterable _filter_3 = IterableExtensions.filter((Iterable)toBeIndexed, (Functions.Function1)_function_10);
            Procedures.Procedure1<URI> _function_11 = new Procedures.Procedure1<URI>(){

                public void apply(URI it) {
                    URI _findSourceRootRelativeURI = FilesAndURIs.findSourceRootRelativeURI(it, request);
                    URI _trimFileExtension = _findSourceRootRelativeURI.trimFileExtension();
                    String javaPath = _trimFileExtension.toString();
                    String _replace = javaPath.replace("/", ".");
                    QualifiedName fqn = Indexer.this.qualifiedNameConverter.toQualifiedName(_replace);
                    TypeResourceDescription.ChangedDelta _changedDelta = new TypeResourceDescription.ChangedDelta(fqn);
                    currentDeltas.add(_changedDelta);
                }
            };
            IterableExtensions.forEach((Iterable)_filter_3, (Procedures.Procedure1)_function_11);
            Iterables.addAll((Collection)allDeltas, (Iterable)currentDeltas);
            toBeIndexed.clear();
            Functions.Function1<URI, Boolean> _function_12 = new Functions.Function1<URI, Boolean>(){

                public Boolean apply(URI it) {
                    boolean _xblockexpression = false;
                    String _fileExtension = it.fileExtension();
                    boolean _equals = Objects.equal((Object)_fileExtension, (Object)"java");
                    if (_equals) {
                        return false;
                    }
                    Map<String, LanguageAccess> _languages = context.getLanguages();
                    String _fileExtension_1 = it.fileExtension();
                    LanguageAccess _get = _languages.get(_fileExtension_1);
                    IResourceDescription.Manager manager = _get.getResourceDescriptionManager();
                    IResourceDescription resourceDescription = oldIndex.getResourceDescription(it);
                    _xblockexpression = Indexer.this.isAffected(resourceDescription, manager, currentDeltas, allDeltas, resourceDescriptions);
                    return _xblockexpression;
                }
            };
            Iterable _filter_4 = IterableExtensions.filter((Iterable)affectionCandidates, (Functions.Function1)_function_12);
            Iterables.addAll((Collection)toBeIndexed, (Iterable)_filter_4);
            currentDeltas.clear();
            boolean _isEmpty = toBeIndexed.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            LOG.info((Object)"Indexing affected files");
        }
        return new IndexResult(allDeltas, allAffected, newIndex);
    }

    private Iterable<URI> primarySources(URI uri, Source2GeneratedMapping mappings) {
        Iterable<URI> _xblockexpression = null;
        Iterable<URI> sources = mappings.getSource(uri);
        Iterable<Object> _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(sources);
        _xifexpression = _isEmpty ? Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})) : sources;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ArrayList<IResourceDescription.Delta> removeDeletedFilesFromIndex(BuildRequest request, final ResourceDescriptionsData oldIndex, final ResourceDescriptionsData newIndex) {
        LOG.info((Object)"Removing deleted files from index");
        final ArrayList deltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
        List<URI> _deletedFiles = request.getDeletedFiles();
        Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

            public void apply(URI it) {
                boolean _notEquals;
                String _fileExtension = it.fileExtension();
                boolean bl = _notEquals = !Objects.equal((Object)_fileExtension, (Object)"java");
                if (_notEquals) {
                    IResourceDescription oldDescription;
                    boolean _notEquals_1;
                    IResourceDescription _resourceDescription = null;
                    if (oldIndex != null) {
                        _resourceDescription = oldIndex.getResourceDescription(it);
                    }
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)(oldDescription = _resourceDescription), null);
                    if (_notEquals_1) {
                        DefaultResourceDescriptionDelta _defaultResourceDescriptionDelta = new DefaultResourceDescriptionDelta(oldDescription, null);
                        deltas.add(_defaultResourceDescriptionDelta);
                    }
                    newIndex.removeDescription(it);
                }
            }
        };
        IterableExtensions.forEach(_deletedFiles, (Procedures.Procedure1)_function);
        return deltas;
    }

    protected Iterable<Object> preIndexChangedResources(Iterable<URI> directlyAffected, final ResourceDescriptionsData oldIndex, final ResourceDescriptionsData newIndex, BuildRequest request, final @Extension BuildContext context) {
        Iterable<Object> _xblockexpression = null;
        LOG.info((Object)"Pre-indexing changed files");
        Iterable<Object> _xtrycatchfinallyexpression = null;
        try {
            Iterable<Object> _xblockexpression_1 = null;
            XtextResourceSet _resourceSet = context.getResourceSet();
            this.compilerPhases.setIndexing((Notifier)_resourceSet, true);
            Functions.Function1<Resource, Object> _function = new Functions.Function1<Resource, Object>(){

                public Object apply(Resource it) {
                    Object _xblockexpression = null;
                    Indexer.this.addToIndex(it, true, oldIndex, newIndex, context);
                    _xblockexpression = null;
                    return _xblockexpression;
                }
            };
            _xtrycatchfinallyexpression = _xblockexpression_1 = context.executeClustered(directlyAffected, _function);
        }
        finally {
            XtextResourceSet _resourceSet = context.getResourceSet();
            this.compilerPhases.setIndexing((Notifier)_resourceSet, false);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected DefaultResourceDescriptionDelta addToIndex(Resource resource, boolean isPreIndexing, ResourceDescriptionsData oldIndex, ResourceDescriptionsData newIndex, BuildContext context) {
        URI uri = resource.getURI();
        Map<String, LanguageAccess> _languages = context.getLanguages();
        String _fileExtension = uri.fileExtension();
        LanguageAccess languageAccess = _languages.get(_fileExtension);
        IResourceDescription.Manager manager = languageAccess.getResourceDescriptionManager();
        IResourceDescription newDescription = manager.getResourceDescription(resource);
        Object _xifexpression = null;
        _xifexpression = isPreIndexing ? new ResolvedResourceDescription(newDescription) : newDescription;
        IResourceDescription toBeAdded = _xifexpression;
        newIndex.addDescription(uri, toBeAdded);
        IResourceDescription _resourceDescription = null;
        if (oldIndex != null) {
            _resourceDescription = oldIndex.getResourceDescription(uri);
        }
        DefaultResourceDescriptionDelta delta = new DefaultResourceDescriptionDelta(_resourceDescription, toBeAdded);
        return delta;
    }

    protected IResourceDescriptions installIndex(XtextResourceSet resourceSet, ResourceDescriptionsData index) {
        IResourceDescriptions _xblockexpression = null;
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
        _xblockexpression = this.resourceDescriptionsProvider.get((ResourceSet)resourceSet);
        return _xblockexpression;
    }

    protected boolean isAffected(IResourceDescription affectionCandidate, IResourceDescription.Manager manager, Collection<IResourceDescription.Delta> newDeltas, Collection<IResourceDescription.Delta> allDeltas, IResourceDescriptions resourceDescriptions) {
        if (manager instanceof IResourceDescription.Manager.AllChangeAware) {
            return ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, affectionCandidate, resourceDescriptions);
        }
        boolean _isEmpty = newDeltas.isEmpty();
        if (_isEmpty) {
            return false;
        }
        return manager.isAffected(newDeltas, affectionCandidate, resourceDescriptions);
    }

    @Data
    public static class IndexResult {
        private final Set<IResourceDescription.Delta> resourceDeltas;
        private final Set<URI> affectedResources;
        private final ResourceDescriptionsData newIndex;

        public IndexResult(Set<IResourceDescription.Delta> resourceDeltas, Set<URI> affectedResources, ResourceDescriptionsData newIndex) {
            this.resourceDeltas = resourceDeltas;
            this.affectedResources = affectedResources;
            this.newIndex = newIndex;
        }

        @Pure
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.resourceDeltas == null ? 0 : this.resourceDeltas.hashCode());
            result = 31 * result + (this.affectedResources == null ? 0 : this.affectedResources.hashCode());
            result = 31 * result + (this.newIndex == null ? 0 : this.newIndex.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexResult other = (IndexResult)obj;
            if (this.resourceDeltas == null ? other.resourceDeltas != null : !this.resourceDeltas.equals(other.resourceDeltas)) {
                return false;
            }
            if (this.affectedResources == null ? other.affectedResources != null : !this.affectedResources.equals(other.affectedResources)) {
                return false;
            }
            return !(this.newIndex == null ? other.newIndex != null : !this.newIndex.equals(other.newIndex));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resourceDeltas", this.resourceDeltas);
            b.add("affectedResources", this.affectedResources);
            b.add("newIndex", (Object)this.newIndex);
            return b.toString();
        }

        @Pure
        public Set<IResourceDescription.Delta> getResourceDeltas() {
            return this.resourceDeltas;
        }

        @Pure
        public Set<URI> getAffectedResources() {
            return this.affectedResources;
        }

        @Pure
        public ResourceDescriptionsData getNewIndex() {
            return this.newIndex;
        }
    }
}

