/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.standalone.incremental.BuildRequest;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FilesAndURIs {
    public static URI asURI(File file) {
        try {
            URI _xblockexpression = null;
            File _canonicalFile = file.getCanonicalFile();
            String _absolutePath = _canonicalFile.getAbsolutePath();
            URI uri = URI.createFileURI((String)_absolutePath);
            URI _xifexpression = null;
            boolean _isDirectory = file.isDirectory();
            _xifexpression = _isDirectory ? uri.appendSegment("") : uri;
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static File asFile(URI uri) {
        try {
            File _xifexpression = null;
            boolean _isFile = uri.isFile();
            if (!_isFile) {
                throw new IllegalArgumentException("Cannot convert non-file URI " + uri + " to file");
            }
            String _fileString = uri.toFileString();
            File _file = new File(_fileString);
            _xifexpression = _file.getCanonicalFile();
            return _xifexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String asPath(URI uri) {
        File _asFile = FilesAndURIs.asFile(uri);
        return _asFile.getPath();
    }

    public static URI asURI(String uri) {
        return URI.createURI((String)uri);
    }

    public static URI asFileURI(String path) {
        try {
            File _file = new File(path);
            String _canonicalPath = _file.getCanonicalPath();
            return URI.createFileURI((String)_canonicalPath);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String asPath(URL url) {
        String _string = url.toString();
        URI _asURI = FilesAndURIs.asURI(_string);
        return FilesAndURIs.asPath(_asURI);
    }

    public static URI findSourceRootRelativeURI(URI uri, BuildRequest request) {
        List<URI> _sourceRoots = request.getSourceRoots();
        return FilesAndURIs.findRelativeURI(uri, _sourceRoots);
    }

    public static URI findRelativeURI(final URI uri, Iterable<URI> baseURIs) {
        Functions.Function1<URI, URI> _function = new Functions.Function1<URI, URI>(){

            public URI apply(URI it) {
                return FilesAndURIs.getRelativeURI(it, uri);
            }
        };
        Iterable _map = IterableExtensions.map(baseURIs, (Functions.Function1)_function);
        Iterable relativeURIs = IterableExtensions.filterNull((Iterable)_map);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)relativeURIs);
        if (_isEmpty) {
            return null;
        }
        Comparator<URI> _function_1 = new Comparator<URI>(){

            @Override
            public int compare(URI $0, URI $1) {
                int _segmentCount = $0.segmentCount();
                int _segmentCount_1 = $1.segmentCount();
                return _segmentCount - _segmentCount_1;
            }
        };
        return (URI)IterableExtensions.min((Iterable)relativeURIs, (Comparator)_function_1);
    }

    private static URI getRelativeURI(URI prefix, URI uri) {
        String _lastSegment;
        boolean _notEquals_1;
        int _segmentCount_1;
        int _segmentCount;
        boolean _lessThan;
        String _scheme_1;
        boolean _notEquals;
        URI _xblockexpression = null;
        boolean _or = false;
        boolean _or_1 = false;
        String _scheme = uri.scheme();
        boolean bl = _notEquals = !Objects.equal((Object)_scheme, (Object)(_scheme_1 = prefix.scheme()));
        _or_1 = _notEquals ? true : (_lessThan = (_segmentCount = uri.segmentCount()) < (_segmentCount_1 = prefix.segmentCount()));
        _or = _or_1 ? true : (_notEquals_1 = !Objects.equal((Object)(_lastSegment = prefix.lastSegment()), (Object)""));
        if (_or) {
            return null;
        }
        int _segmentCount_2 = prefix.segmentCount();
        int _minus = _segmentCount_2 - 1;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus, true);
        for (Integer i : _doubleDotLessThan) {
            String _segment_1;
            boolean _notEquals_2;
            String _segment = prefix.segment(i.intValue());
            boolean bl2 = _notEquals_2 = !Objects.equal((Object)_segment, (Object)(_segment_1 = uri.segment(i.intValue())));
            if (!_notEquals_2) continue;
            return null;
        }
        String[] _segments = uri.segments();
        int _segmentCount_3 = prefix.segmentCount();
        int _minus_1 = _segmentCount_3 - 1;
        int _segmentCount_4 = uri.segmentCount();
        List _subList = ((List)Conversions.doWrapArray((Object)_segments)).subList(_minus_1, _segmentCount_4);
        String _join = IterableExtensions.join(_subList, (CharSequence)"/");
        _xblockexpression = URI.createURI((String)_join);
        return _xblockexpression;
    }
}

