/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneBuilder {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = Logger.getLogger(StandaloneBuilder.class);
            return _logger;
        }
    }.apply();
    private Map<String, LanguageAccess> _languages;
    private Iterable<String> _sourceDirs;
    private Iterable<String> _classPathEntries;
    private File _tempDir = new Functions.Function0<File>(){

        public File apply() {
            File _createTempDir = Files.createTempDir();
            return _createTempDir;
        }
    }.apply();
    private String _encoding;
    private String _classPathLookUpFilter;
    private boolean _failOnValidationError = true;
    @Inject
    private IndexedJvmTypeAccess jvmTypeAccess;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private AbstractFileSystemAccess commonFileAccess;
    @Inject
    private IIssueHandler issueHandler;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IJavaCompiler compiler;

    public Map<String, LanguageAccess> getLanguages() {
        return this._languages;
    }

    public void setLanguages(Map<String, LanguageAccess> languages) {
        this._languages = languages;
    }

    public Iterable<String> getSourceDirs() {
        return this._sourceDirs;
    }

    public void setSourceDirs(Iterable<String> sourceDirs) {
        this._sourceDirs = sourceDirs;
    }

    public Iterable<String> getClassPathEntries() {
        return this._classPathEntries;
    }

    public void setClassPathEntries(Iterable<String> classPathEntries) {
        this._classPathEntries = classPathEntries;
    }

    public File getTempDir() {
        return this._tempDir;
    }

    public void setTempDir(File tempDir) {
        this._tempDir = tempDir;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getClassPathLookUpFilter() {
        return this._classPathLookUpFilter;
    }

    public void setClassPathLookUpFilter(String classPathLookUpFilter) {
        this._classPathLookUpFilter = classPathLookUpFilter;
    }

    public boolean isFailOnValidationError() {
        return this._failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this._failOnValidationError = failOnValidationError;
    }

    public void setTempDir(String pathAsString) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)pathAsString, null);
        if (_notEquals) {
            File _file;
            this._tempDir = _file = new File(pathAsString);
        }
    }

    public boolean launch() {
        boolean _notEquals;
        Functions.Function1<LanguageAccess, Boolean> _function;
        Map<String, LanguageAccess> _languages = this.getLanguages();
        Collection<LanguageAccess> _values = _languages.values();
        boolean needsJava = IterableExtensions.exists(_values, (Functions.Function1)(_function = new Functions.Function1<LanguageAccess, Boolean>(){

            public Boolean apply(LanguageAccess it) {
                boolean _isLinksAgainstJava = it.isLinksAgainstJava();
                return _isLinksAgainstJava;
            }
        }));
        if (needsJava) {
            LOG.info((Object)"Using common types.");
        }
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        LOG.info((Object)"Collecting source models.");
        long startedAt = System.currentTimeMillis();
        Iterable rootsToTravers = this.getClassPathEntries();
        String _classPathLookUpFilter = this.getClassPathLookUpFilter();
        boolean bl = _notEquals = !Objects.equal((Object)_classPathLookUpFilter, null);
        if (_notEquals) {
            Iterable _filter;
            LOG.info((Object)"Class path look up filter is active.");
            String _classPathLookUpFilter_1 = this.getClassPathLookUpFilter();
            final Pattern cpLookUpFilter = Pattern.compile(_classPathLookUpFilter_1);
            Iterable<String> _classPathEntries = this.getClassPathEntries();
            Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String root) {
                    Matcher _matcher = cpLookUpFilter.matcher(root);
                    boolean _matches = _matcher.matches();
                    return _matches;
                }
            };
            Iterable _converted_rootsToTravers = rootsToTravers = (_filter = IterableExtensions.filter(_classPathEntries, (Functions.Function1)_function_1));
            int _length = ((Object[])Conversions.unwrapArray((Object)_converted_rootsToTravers, Object.class)).length;
            String _plus = "Investigating " + Integer.valueOf(_length);
            String _plus_1 = String.valueOf(_plus) + " of ";
            Iterable<String> _classPathEntries_1 = this.getClassPathEntries();
            int _length_1 = ((Object[])Conversions.unwrapArray(_classPathEntries_1, Object.class)).length;
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_length_1);
            String _plus_3 = String.valueOf(_plus_2) + " class path entries.";
            LOG.info((Object)_plus_3);
        }
        Iterable<String> _sourceDirs = this.getSourceDirs();
        Iterable _plus_4 = Iterables.concat(_sourceDirs, rootsToTravers);
        this.collectResources(_plus_4, (ResourceSet)resourceSet);
        long _currentTimeMillis = System.currentTimeMillis();
        long _minus = _currentTimeMillis - startedAt;
        String _plus_5 = "Finished collecting source models. Took: " + Long.valueOf(_minus);
        String _plus_6 = String.valueOf(_plus_5) + " ms.";
        LOG.debug((Object)_plus_6);
        Iterable<String> _sourceDirs_1 = this.getSourceDirs();
        Iterable<String> _classPathEntries_2 = this.getClassPathEntries();
        Iterable allClassPathEntries = Iterables.concat(_sourceDirs_1, _classPathEntries_2);
        if (needsJava) {
            LOG.info((Object)"Installing type provider.");
            this.installTypeProvider(allClassPathEntries, resourceSet, null);
        }
        ResourceDescriptionsData index = this.fillIndex(resourceSet);
        Iterable<String> _sourceDirs_2 = this.getSourceDirs();
        List<Resource> sourceResources = this.collectResources(_sourceDirs_2, (ResourceSet)resourceSet);
        if (needsJava) {
            File _generateStubs = this.generateStubs(index, sourceResources);
            String stubsClasses = this.compileStubs(_generateStubs);
            LOG.info((Object)"Installing type provider for stubs.");
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{stubsClasses});
            Iterable _plus_7 = Iterables.concat((Iterable)allClassPathEntries, (Iterable)_newArrayList);
            this.installTypeProvider(_plus_7, resourceSet, this.jvmTypeAccess);
        }
        Procedures.Procedure1<Resource> _function_2 = new Procedures.Procedure1<Resource>(){

            public void apply(Resource it) {
                it.getContents();
            }
        };
        IterableExtensions.forEach(sourceResources, (Procedures.Procedure1)_function_2);
        Procedures.Procedure1<Resource> _function_3 = new Procedures.Procedure1<Resource>(){

            public void apply(Resource it) {
                EcoreUtil2.resolveLazyCrossReferences((Resource)it, (CancelIndicator)CancelIndicator.NullImpl);
            }
        };
        IterableExtensions.forEach(sourceResources, (Procedures.Procedure1)_function_3);
        boolean isErrorFree = this.validate(sourceResources);
        boolean _and = false;
        boolean _isFailOnValidationError = this.isFailOnValidationError();
        if (!_isFailOnValidationError) {
            _and = false;
        } else {
            boolean _not = !isErrorFree;
            boolean bl2 = _and = _isFailOnValidationError && _not;
        }
        if (_and) {
            return isErrorFree;
        }
        this.generate(sourceResources);
        return isErrorFree;
    }

    protected ResourceDescriptionsData fillIndex(XtextResourceSet set) {
        ResourceDescriptionsData _resourceDescriptionsData;
        EList _resources = set.getResources();
        ArrayList _arrayList = new ArrayList(_resources);
        Functions.Function1<Resource, IResourceDescription> _function = new Functions.Function1<Resource, IResourceDescription>(){

            public IResourceDescription apply(Resource it) {
                LanguageAccess _languageAccess = StandaloneBuilder.this.languageAccess(it);
                IResourceDescription.Manager _resourceDescriptionManager = _languageAccess.getResourceDescriptionManager();
                IResourceDescription _resourceDescription = _resourceDescriptionManager.getResourceDescription(it);
                return _resourceDescription;
            }
        };
        List descriptions = ListExtensions.map(_arrayList, (Functions.Function1)_function);
        ResourceDescriptionsData index = _resourceDescriptionsData = new ResourceDescriptionsData(descriptions);
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)set, index);
        return index;
    }

    protected String compileStubs(File stubsDir) {
        File stubsClasses = this.createTempDir("classes");
        Iterable<String> _classPathEntries = this.getClassPathEntries();
        this.compiler.setClassPath(_classPathEntries);
        String _absolutePath = stubsDir.getAbsolutePath();
        String _plus = "Compiling stubs located in " + _absolutePath;
        LOG.info((Object)_plus);
        Iterable<String> _sourceDirs = this.getSourceDirs();
        String _absolutePath_1 = stubsDir.getAbsolutePath();
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_1});
        Iterable _plus_1 = Iterables.concat(_sourceDirs, (Iterable)_newArrayList);
        IJavaCompiler.CompilationResult result = this.compiler.compile(_plus_1, stubsClasses);
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)result), (Object)((Object)IJavaCompiler.CompilationResult.SKIPPED))) {
            _matched = true;
            LOG.info((Object)"Nothing to compile. Stubs compilation was skipped.");
        }
        if (!_matched && Objects.equal((Object)((Object)result), (Object)((Object)IJavaCompiler.CompilationResult.FAILED))) {
            _matched = true;
            LOG.info((Object)"Stubs compilation finished with errors.");
        }
        return stubsClasses.getAbsolutePath();
    }

    protected File generateStubs(final ResourceDescriptionsData data, List<? extends Resource> resources) {
        boolean _notEquals;
        File stubsDir = this.createTempDir("stubs");
        String _absolutePath = stubsDir.getAbsolutePath();
        String _plus = "Generating stubs into " + _absolutePath;
        LOG.info((Object)_plus);
        String _encoding = this.getEncoding();
        boolean bl = _notEquals = !Objects.equal((Object)_encoding, null);
        if (_notEquals) {
            String _encoding_1 = this.getEncoding();
            this.encodingProvider.setDefaultEncoding(_encoding_1);
        }
        String _absolutePath_1 = stubsDir.getAbsolutePath();
        this.commonFileAccess.setOutputPath("DEFAULT_OUTPUT", _absolutePath_1);
        Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

            public Boolean apply(Resource it) {
                LanguageAccess _languageAccess = StandaloneBuilder.this.languageAccess(it);
                boolean _isLinksAgainstJava = _languageAccess.isLinksAgainstJava();
                return _isLinksAgainstJava;
            }
        };
        Iterable generateStubs = IterableExtensions.filter(resources, (Functions.Function1)_function);
        Procedures.Procedure1<Resource> _function_1 = new Procedures.Procedure1<Resource>(){

            public void apply(Resource it) {
                LanguageAccess _languageAccess = StandaloneBuilder.this.languageAccess(it);
                IStubGenerator _stubGenerator = _languageAccess.getStubGenerator();
                URI _uRI = it.getURI();
                IResourceDescription _resourceDescription = data.getResourceDescription(_uRI);
                _stubGenerator.doGenerateStubs((IFileSystemAccess)StandaloneBuilder.this.commonFileAccess, _resourceDescription);
            }
        };
        IterableExtensions.forEach((Iterable)generateStubs, (Procedures.Procedure1)_function_1);
        return stubsDir;
    }

    protected boolean validate(List<Resource> sourceResources) {
        ArrayList allIssues = CollectionLiterals.newArrayList((Object[])new Issue[0]);
        for (Resource resource : sourceResources) {
            LanguageAccess _languageAccess = this.languageAccess(resource);
            IResourceValidator resourceValidator = _languageAccess.getResourceValidator();
            List validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
            allIssues.addAll(validationResult);
        }
        return this.issueHandler.handleIssue(allIssues);
    }

    protected void generate(List<Resource> sourceResources) {
        for (Resource it : sourceResources) {
            boolean _notEquals;
            URI _uRI = it.getURI();
            String _lastSegment = _uRI.lastSegment();
            String _plus = "Starting generator for input: '" + _lastSegment;
            String _plus_1 = String.valueOf(_plus) + "'";
            LOG.info((Object)_plus_1);
            String _encoding = this.getEncoding();
            boolean bl = _notEquals = !Objects.equal((Object)_encoding, null);
            if (_notEquals) {
                IEncodingProvider _encodingProvider;
                LanguageAccess _languageAccess = this.languageAccess(it);
                IEncodingProvider provider = _encodingProvider = _languageAccess.getEncodingProvider();
                boolean _matched = false;
                if (!_matched && provider instanceof IEncodingProvider.Runtime) {
                    IEncodingProvider.Runtime _runtime = (IEncodingProvider.Runtime)provider;
                    _matched = true;
                    String _encoding_1 = this.getEncoding();
                    _runtime.setDefaultEncoding(_encoding_1);
                }
                if (!_matched) {
                    String _encoding_1 = this.getEncoding();
                    String _plus_2 = "Couldn't set encoding '" + _encoding_1;
                    String _plus_3 = String.valueOf(_plus_2) + "' for file '";
                    URI _uRI_1 = it.getURI();
                    String _plus_4 = String.valueOf(_plus_3) + _uRI_1;
                    String _plus_5 = String.valueOf(_plus_4) + "'. Only subclasses of IEncodingProvider.Runtime are supported.";
                    LOG.debug((Object)_plus_5);
                }
            }
            LanguageAccess _languageAccess_1 = this.languageAccess(it);
            IGenerator _generator = _languageAccess_1.getGenerator();
            LanguageAccess _languageAccess_2 = this.languageAccess(it);
            JavaIoFileSystemAccess _fileSystemAccess = _languageAccess_2.getFileSystemAccess();
            _generator.doGenerate(it, (IFileSystemAccess)_fileSystemAccess);
        }
    }

    private LanguageAccess languageAccess(Resource resource) {
        Map<String, LanguageAccess> _languages = this.getLanguages();
        URI _uRI = resource.getURI();
        String _fileExtension = _uRI.fileExtension();
        LanguageAccess _get = _languages.get(_fileExtension);
        return _get;
    }

    protected File createTempDir(String subDir) {
        try {
            boolean _not;
            File _file;
            File _tempDir = this.getTempDir();
            File file = _file = new File(_tempDir, subDir);
            boolean _and = false;
            boolean _mkdirs = file.mkdirs();
            boolean bl = _not = !_mkdirs;
            if (!_not) {
                _and = false;
            } else {
                boolean _exists = file.exists();
                boolean _not_1 = !_exists;
                boolean bl2 = _and = _not && _not_1;
            }
            if (_and) {
                String _absolutePath = file.getAbsolutePath();
                String _plus = "Failed to create directory '" + _absolutePath;
                String _plus_1 = String.valueOf(_plus) + "'";
                IOException _iOException = new IOException(_plus_1);
                throw _iOException;
            }
            return file;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void installTypeProvider(Iterable<String> classPathRoots, XtextResourceSet resSet, IndexedJvmTypeAccess typeAccess) {
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resSet, typeAccess);
        resSet.setClasspathURIContext((Object)classLoader);
    }

    private URLClassLoader createURLClassLoader(Iterable<String> classPathEntries) {
        Functions.Function1<String, URL> _function = new Functions.Function1<String, URL>(){

            public URL apply(String str) {
                try {
                    File _file = new File(str);
                    java.net.URI _uRI = _file.toURI();
                    URL _uRL = _uRI.toURL();
                    return _uRL;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterable classPathUrls = IterableExtensions.map(classPathEntries, (Functions.Function1)_function);
        URLClassLoader _uRLClassLoader = new URLClassLoader((URL[])Conversions.unwrapArray((Object)classPathUrls, URL.class));
        return _uRLClassLoader;
    }

    protected List<Resource> collectResources(Iterable<String> roots, final ResourceSet resourceSet) {
        NameBasedFilter _nameBasedFilter;
        Map<String, LanguageAccess> _languages = this.getLanguages();
        Set<String> _keySet = _languages.keySet();
        String extensions = IterableExtensions.join(_keySet, (CharSequence)"|");
        final NameBasedFilter nameBasedFilter = _nameBasedFilter = new NameBasedFilter();
        String _plus = ".*\\.(?:(" + extensions;
        String _plus_1 = String.valueOf(_plus) + "))$";
        nameBasedFilter.setRegularExpression(_plus_1);
        final ArrayList resources = CollectionLiterals.newArrayList((Object[])new Resource[0]);
        PathTraverser _pathTraverser = new PathTraverser();
        List _list = IterableExtensions.toList(roots);
        Predicate<URI> _function = new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                if (matches) {
                    boolean _isDebugEnabled = LOG.isDebugEnabled();
                    if (_isDebugEnabled) {
                        String _plus = "Adding file '" + input;
                        String _plus_1 = String.valueOf(_plus) + "'";
                        LOG.debug((Object)_plus_1);
                    }
                    Resource _resource = resourceSet.getResource(input, true);
                    resources.add(_resource);
                }
                return matches;
            }
        };
        _pathTraverser.resolvePathes(_list, (Predicate)_function);
        return resources;
    }

    public IJavaCompiler getCompiler() {
        return this.compiler;
    }
}

