/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.compiler;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.standalone.compiler.AccessibleReferenceCollection;
import org.eclipse.xtext.builder.standalone.compiler.ClassFileEObjectDescription;
import org.eclipse.xtext.builder.standalone.compiler.ClassFileResourceDescription;
import org.eclipse.xtext.builder.standalone.compiler.EclipseJavaCompiler;
import org.eclipse.xtext.builder.standalone.incremental.ExtendedEObjectInputStream;
import org.eclipse.xtext.builder.standalone.incremental.ExtendedEObjectOutputStream;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;

class SerializedCompilerState {
    private static final Logger LOG = Logger.getLogger(EclipseJavaCompiler.class);
    private static final int SERIALIZATION_VERSION = 1;
    private static final int HASH_CODE = 0;
    private static final int PATH = 1;
    private static final int PATHS = 2;
    private static final int STRING = 3;
    long duration;
    HashCode hashedClasspath;
    final Map<IPath, HashCode> inputFiles = new HashMap<IPath, HashCode>();
    final Map<IPath, HashCode> outputFiles = new HashMap<IPath, HashCode>();
    final Map<IPath, AccessibleReferenceCollection> referenceInformation = new HashMap<IPath, AccessibleReferenceCollection>();
    final Map<IPath, IPath[]> inputToOutputFiles = new HashMap<IPath, IPath[]>();
    final Map<IPath, IPath> outputToInputFile = new HashMap<IPath, IPath>();
    final Map<IPath, String> outputToTypeName = new HashMap<IPath, String>();

    SerializedCompilerState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<URI, ClassFileResourceDescription> resourceDescriptions() {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            HashMap<URI, ClassFileResourceDescription> result = new HashMap<URI, ClassFileResourceDescription>();
            for (IPath[] outputFiles : this.inputToOutputFiles.values()) {
                if (outputFiles == null || outputFiles.length <= 0) continue;
                ArrayList<IPath> sorted = new ArrayList<IPath>(Arrays.asList(outputFiles));
                Collections.sort(sorted, Comparator.comparing(p -> p.removeFileExtension().toString()));
                ClassFileResourceDescription currentDescription = null;
                String currentType = "";
                int i = 0;
                do {
                    IPath outputFile = (IPath)sorted.get(i);
                    String typeName = this.outputToTypeName.get(outputFile).replace('/', '.');
                    if (currentType.equals("") || !typeName.startsWith(currentType + "$")) {
                        currentType = typeName;
                        currentDescription = new ClassFileResourceDescription(ClassURIHelper.OBJECTS_URI.appendSegment(typeName), new HashSet<ClassFileEObjectDescription>());
                        result.put(currentDescription.uri, currentDescription);
                    }
                    currentDescription.descriptions.add(new ClassFileEObjectDescription(currentDescription.uri.appendFragment(typeName), this.outputFiles.get(outputFile)));
                } while (++i < sorted.size());
            }
            HashMap<URI, ClassFileResourceDescription> hashMap = result;
            return hashMap;
        }
        finally {
            LOG.trace((Object)("Created Xtext index for Java class files in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SerializedCompilerState from(File file) {
        SerializedCompilerState result = new SerializedCompilerState();
        if (file.exists()) {
            Stopwatch sw = Stopwatch.createStarted();
            boolean failed = false;
            try (BufferedInputStream buffy = new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));){
                ExtendedEObjectInputStream in = new ExtendedEObjectInputStream(buffy, 128);
                result.read(in);
            }
            catch (IOException e) {
                failed = true;
                LOG.error((Object)"Failed to read compiler state.", (Throwable)e);
            }
            finally {
                if (!failed) {
                    LOG.trace((Object)("Read compiler state in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms."));
                }
            }
        } else {
            result.hashedClasspath = HashCode.fromInt((int)0);
        }
        return result;
    }

    private void read(ExtendedEObjectInputStream in) throws IOException {
        if (in.readCompressedInt() != 1) {
            this.hashedClasspath = HashCode.fromInt((int)0);
            return;
        }
        this.hashedClasspath = in.readHashCode();
        this.readFiles(in, this.inputFiles, 0, HashCode.class);
        this.readFiles(in, this.outputFiles, 0, HashCode.class);
        this.readFiles(in, this.outputToInputFile, 1, IPath.class);
        this.readFiles(in, this.inputToOutputFiles, 2, IPath[].class);
        this.readFiles(in, this.outputToTypeName, 3, String.class);
        this.readReferences(in);
        this.duration = in.readLong();
    }

    private void readReferences(ExtendedEObjectInputStream in) throws IOException {
        int size = in.readCompressedInt();
        for (int i = 0; i < size; ++i) {
            IPath p = in.readPath();
            char[][][] qn = new char[in.readCompressedInt()][][];
            for (int j = 0; j < qn.length; ++j) {
                qn[j] = in.readCharCharArray();
            }
            char[][] roots = in.readCharCharArray();
            char[][] simpleNames = in.readCharCharArray();
            AccessibleReferenceCollection referenceCollection = new AccessibleReferenceCollection(qn, simpleNames, roots);
            this.referenceInformation.put(p, referenceCollection);
        }
    }

    private <T> void readFiles(ExtendedEObjectInputStream in, Map<IPath, T> files, int mode, Class<T> type) throws IOException {
        int size = in.readCompressedInt();
        block6: for (int i = 0; i < size; ++i) {
            IPath p = in.readPath();
            switch (mode) {
                case 0: {
                    files.put(p, type.cast(in.readHashCode()));
                    continue block6;
                }
                case 1: {
                    files.put(p, type.cast(in.readPath()));
                    continue block6;
                }
                case 2: {
                    IPath[] pathArray = new IPath[in.readCompressedInt()];
                    for (int j = 0; j < pathArray.length; ++j) {
                        pathArray[j] = in.readPath();
                    }
                    files.put(p, type.cast(pathArray));
                    continue block6;
                }
                case 3: {
                    files.put(p, type.cast(in.readSegmentedString()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void to(File file, Stopwatch rootStopwatch) {
        Stopwatch sw = Stopwatch.createStarted();
        boolean failed = false;
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to store compiler state.", (Throwable)e);
            return;
        }
        long uncompressedCount = 0L;
        long compressedCount = 0L;
        try (CountingOutputStream baseOut = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
             CountingOutputStream countingOut = new CountingOutputStream((OutputStream)new BufferedOutputStream(new GZIPOutputStream((OutputStream)baseOut)));){
            ExtendedEObjectOutputStream out = new ExtendedEObjectOutputStream((OutputStream)countingOut, 128);
            out.writeCompressedInt(1);
            out.writeHashCode(this.hashedClasspath);
            this.writeFiles(out, this.inputFiles, 0);
            this.writeFiles(out, this.outputFiles, 0);
            this.writeFiles(out, this.outputToInputFile, 1);
            this.writeFiles(out, this.inputToOutputFiles, 2);
            this.writeFiles(out, this.outputToTypeName, 3);
            this.writeReferences(out);
            rootStopwatch.stop();
            if (this.duration == 0L) {
                this.duration = rootStopwatch.elapsed(TimeUnit.MILLISECONDS);
            }
            out.writeLong(this.duration);
            out.flush();
            countingOut.flush();
            countingOut.close();
            compressedCount = baseOut.getCount();
            uncompressedCount = countingOut.getCount();
        }
        catch (IOException e) {
            failed = true;
            LOG.error((Object)"Failed to store compiler state.", (Throwable)e);
        }
        finally {
            if (!failed) {
                LOG.trace((Object)("Stored compiler state in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms (" + uncompressedCount + " bytes compressed to " + compressedCount + " bytes)."));
            }
        }
    }

    private void writeReferences(ExtendedEObjectOutputStream out) throws IOException {
        out.writeCompressedInt(this.referenceInformation.size());
        for (Map.Entry<IPath, AccessibleReferenceCollection> entry : this.referenceInformation.entrySet()) {
            out.writePath(entry.getKey());
            AccessibleReferenceCollection referenceCollection = entry.getValue();
            char[][][] qn = referenceCollection.qualifiedNameReferences();
            out.writeCompressedInt(qn.length);
            for (char[][] n : qn) {
                out.writeCharCharArray(n);
            }
            out.writeCharCharArray(referenceCollection.rootReferences());
            out.writeCharCharArray(referenceCollection.simpleNameReferences());
        }
    }

    private void writeFiles(ExtendedEObjectOutputStream out, Map<IPath, ?> files, int mode) throws IOException {
        out.writeCompressedInt(files.size());
        block6: for (Map.Entry<IPath, ?> entry : files.entrySet()) {
            out.writePath(entry.getKey());
            switch (mode) {
                case 0: {
                    out.writeHashCode((HashCode)entry.getValue());
                    break;
                }
                case 1: {
                    out.writePath((IPath)entry.getValue());
                    break;
                }
                case 2: {
                    IPath[] pathArray = (IPath[])entry.getValue();
                    out.writeCompressedInt(pathArray.length);
                    for (IPath path : pathArray) {
                        out.writePath(path);
                    }
                    continue block6;
                }
                case 3: {
                    out.writeSegmentedString((String)entry.getValue());
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.hashedClasspath, this.inputFiles, Maps.transformValues(this.inputToOutputFiles, Arrays::asList), this.outputFiles, this.outputToInputFile, this.outputToTypeName, this.referenceInformation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedCompilerState other = (SerializedCompilerState)obj;
        return Objects.equals(this.hashedClasspath, other.hashedClasspath) && Objects.equals(this.inputFiles, other.inputFiles) && Objects.equals(Maps.transformValues(this.inputToOutputFiles, Arrays::asList), Maps.transformValues(other.inputToOutputFiles, Arrays::asList)) && Objects.equals(this.outputFiles, other.outputFiles) && Objects.equals(this.outputToInputFile, other.outputToInputFile) && Objects.equals(this.outputToTypeName, other.outputToTypeName) && Objects.equals(this.referenceInformation, other.referenceInformation);
    }
}

