/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.config;

import java.sql.Timestamp;
import javax.annotation.PostConstruct;
import org.eclipse.vorto.repository.account.Role;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.sso.boschid.EidpUtils;
import org.eclipse.vorto.repository.web.config.RepositoryConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;

@Configuration
@Profile(value={"local"})
public class RepositoryConfigurationLocal
extends RepositoryConfiguration {
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private PasswordEncoder encoder;

    @PostConstruct
    public void setUpTestUser() {
        this.userRepository.save((Object)this.newUser("admin", "admin", false, "alexander.edelmann@bosch-si.com", Role.ADMIN));
        this.userRepository.save((Object)this.newUser("testuser", "testuser", false, "erleczars.mantos@bosch-si.com", Role.USER));
        this.userRepository.save((Object)this.newUser("testuser2", "testuser2", false, "testuser2@my.com", Role.USER));
    }

    private User newUser(String username, String password, boolean hasWatchOnRepo, String email, Role role) {
        User user = new User();
        user.setUsername(username);
        user.setPassword(this.encoder.encode((CharSequence)password));
        user.setHasWatchOnRepository(hasWatchOnRepo);
        user.setEmail(email);
        user.setRoles(role);
        user.setDateCreated(new Timestamp(System.currentTimeMillis()));
        user.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        return user;
    }

    @Bean
    public AccessTokenProvider accessTokenProvider() {
        return EidpUtils.accessTokenProvider();
    }
}

