/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Home Controller", description="REST API to get currently logged in User ")
@RestController
public class HomeController {
    @ApiOperation(value="Returns the currently logged in User")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(value={"/user", "/me"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getUser(Principal user, HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (user == null) {
            return new ResponseEntity(map, HttpStatus.UNAUTHORIZED);
        }
        for (GrantedAuthority authority : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
            map.put("role", authority.getAuthority());
        }
        map.put("name", user.getName());
        return new ResponseEntity(map, HttpStatus.OK);
    }
}

