/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.utils;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.internal.service.utils.ModelIdHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelIdHelper {
    private ModelId modelId;
    private static final String PATH_DELIMITER = "/";

    public ModelIdHelper(ModelId modelId) {
        this.modelId = modelId;
    }

    public String getFullPath() {
        StringBuilder path = new StringBuilder(this.getNamespacePath());
        path.append("/");
        path.append(this.modelId.getName());
        path.append("/");
        path.append(this.modelId.getVersion());
        return path.toString();
    }

    public String getNamespacePath() {
        StringBuilder path = new StringBuilder("/");
        StringTokenizer tokenizer = new StringTokenizer(this.modelId.getNamespace(), ".");
        while (tokenizer.hasMoreTokens()) {
            path.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            path.append("/");
        }
        return path.toString();
    }

    public static ModelId fromPath(String path) {
        String[] pathFragments = path.substring(1).split("/");
        return new ModelId(pathFragments[pathFragments.length - 2], ModelIdHelper.convertToNamespace((String[])pathFragments), pathFragments[pathFragments.length - 1]);
    }

    private static String convertToNamespace(String[] fragments) {
        StringBuilder namespaceBuilder = new StringBuilder();
        for (int i = 0; i < fragments.length - 2; ++i) {
            namespaceBuilder.append(fragments[i]);
            if (i >= fragments.length - 3) continue;
            namespaceBuilder.append(".");
        }
        return namespaceBuilder.toString();
    }

    public Iterator<String> iterator() {
        return new StringTokenizerIterator(this.getFullPath());
    }
}

